/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Craft;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

class Crafting
extends Craft {
    private static final String NBT_RECIPE = "Recipe";
    private NonNullList<ItemStack> recipe;

    Crafting(ICraftingPattern pattern, boolean root, NonNullList<ItemStack> recipe) {
        super(pattern, root);
        this.recipe = recipe;
    }

    Crafting(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        super(network, tag);
        this.recipe = NonNullList.func_191196_a();
        ListNBT tookList = tag.func_150295_c(NBT_RECIPE, 10);
        for (int i = 0; i < tookList.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(tookList.func_150305_b(i));
            this.recipe.add((Object)stack);
        }
    }

    NonNullList<ItemStack> getRecipe() {
        return this.recipe;
    }

    @Override
    CompoundNBT writeToNbt() {
        CompoundNBT tag = super.writeToNbt();
        ListNBT tookList = new ListNBT();
        for (ItemStack took : this.recipe) {
            tookList.add((Object)StackUtils.serializeStackToNbt(took));
        }
        tag.func_218657_a(NBT_RECIPE, (INBT)tookList);
        return tag;
    }
}

