/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import openmods.utils.EnchantmentUtils;

public class ItemXPTome
extends Item {
    public static final String NAME = "xp_book";
    public static final int MAX_STORAGE = 1395;
    private static final Style TOOLTIP_STYLE = new Style().func_150238_a(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_1 = new TranslationTextComponent("xpbook.tooltip.1", new Object[0]).func_150255_a(TOOLTIP_STYLE);
    private static final ITextComponent TOOLTIP_2 = new TranslationTextComponent("xpbook.tooltip.2", new Object[0]).func_150255_a(TOOLTIP_STYLE);
    private final Random random = new Random();

    public ItemXPTome() {
        super(new Item.Properties().func_200918_c(1395).func_200916_a(ItemGroup.field_78026_f));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_213453_ef() && this.getXPStored(stack) != 1395) {
            int playerXP = EnchantmentUtils.getPlayerXP(player);
            if (playerXP == 0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, playerXP);
            EnchantmentUtils.addPlayerXP(player, -actuallyStored);
            if (!world.field_72995_K) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!player.func_213453_ef() && this.getXPStored(stack) != 0) {
            EnchantmentUtils.addPlayerXP(player, this.getXPStored(stack));
            this.setStoredXP(stack, 0);
            if (!world.field_72995_K) {
                float pitchMultiplier = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getXPStored(stack) > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(TOOLTIP_1);
        tooltip.add(TOOLTIP_2);
        tooltip.add(new TranslationTextComponent("xpbook.tooltip.3", new Object[]{this.getXPStored(stack), 1395}).func_150255_a(TOOLTIP_STYLE));
    }

    public int addXP(ItemStack stack, int amount) {
        int stored = this.getXPStored(stack);
        if (stored + amount > 1395) {
            this.setStoredXP(stack, 1395);
            return 1395 - stored;
        }
        this.setStoredXP(stack, stored + amount);
        return amount;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.func_196085_b(1395 - amount);
    }

    public int getXPStored(ItemStack stack) {
        return 1395 - stack.func_77952_i();
    }
}

