/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.api.crafting.recipe.fluid;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidIngredient();
    @Nullable
    private final Tag<Fluid> tag;
    @Nullable
    private final Fluid fluid;
    private final int amount;

    public FluidIngredient(@Nonnull Tag<Fluid> tag) {
        this(tag, 1000);
    }

    public FluidIngredient(@Nonnull Tag<Fluid> tag, int amount) {
        this.tag = tag;
        this.fluid = null;
        this.amount = amount;
    }

    public FluidIngredient(@Nonnull Fluid fluid) {
        this(fluid, 1000);
    }

    public FluidIngredient(@Nonnull Fluid fluid, int amount) {
        this.fluid = fluid;
        this.tag = null;
        this.amount = amount;
    }

    private FluidIngredient() {
        this.tag = null;
        this.fluid = null;
        this.amount = 1000;
    }

    @Nullable
    public Tag<Fluid> getTag() {
        return this.tag;
    }

    public List<FluidStack> getFluids() {
        if (this.tag != null) {
            return this.tag.func_199885_a().stream().map(f -> new FluidStack(f, 1000)).collect(Collectors.toList());
        }
        if (this.fluid != null) {
            return Collections.singletonList(new FluidStack(this.fluid, 1000));
        }
        return Collections.emptyList();
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public boolean test(FluidStack stack) {
        return stack.getAmount() >= this.amount && this.testIgnoreAmount(stack);
    }

    public boolean testIgnoreAmount(FluidStack stack) {
        return this.tag != null && stack.getFluid().func_207185_a(this.tag) || this.fluid != null && stack.getFluid() == this.fluid;
    }

    public static FluidIngredient deserialize(JsonObject json) {
        if (json.has("tag") && json.has("fluid")) {
            throw new JsonSyntaxException("Fluid ingredient should have 'tag' or 'fluid', not both");
        }
        int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
        if (json.has("tag")) {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            return new FluidIngredient((Tag<Fluid>)new FluidTags.Wrapper(id), amount);
        }
        if (json.has("fluid")) {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
            Fluid fluid = (Fluid)Objects.requireNonNull(ForgeRegistries.FLUIDS.getValue(id));
            return new FluidIngredient(fluid, amount);
        }
        throw new JsonSyntaxException("Fluid ingredient should have either 'tag' or 'fluid'");
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        boolean isTag = buffer.readBoolean();
        ResourceLocation id = buffer.func_192575_l();
        return isTag ? new FluidIngredient((Tag<Fluid>)new FluidTags.Wrapper(id)) : new FluidIngredient((Fluid)Objects.requireNonNull(ForgeRegistries.FLUIDS.getValue(id)));
    }

    public void write(PacketBuffer buffer) {
        boolean isTag = this.tag != null;
        buffer.writeBoolean(isTag);
        if (isTag) {
            buffer.func_192572_a(this.tag.func_199886_b());
        } else if (this.fluid != null) {
            buffer.func_192572_a(Objects.requireNonNull(this.fluid.getRegistryName()));
        } else {
            buffer.func_192572_a(new ResourceLocation("null"));
        }
    }
}

