/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity;

import com.github.alexthe666.citadel.server.entity.IEntityData;
import com.github.alexthe666.citadel.server.entity.WeakIdentityHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;

public enum EntityDataHandler {
    INSTANCE;

    private Map<Entity, List<IEntityData<?>>> registeredEntityData = new WeakIdentityHashMap();

    public <T extends Entity> void registerExtendedEntityData(T entity, IEntityData<T> entityData) {
        List<IEntityData<?>> registered = this.registeredEntityData.get(entity);
        if (registered == null) {
            registered = new ArrayList();
        }
        if (!registered.contains(entityData)) {
            registered.add(entityData);
        }
        this.registeredEntityData.put(entity, registered);
    }

    public <T extends Entity> IEntityData<T> getEntityData(T entity, String identifier) {
        List<IEntityData<T>> managers = this.getEntityData(entity);
        if (managers != null) {
            for (IEntityData<T> manager : managers) {
                if (!manager.getID().equals(identifier)) continue;
                return manager;
            }
        }
        return null;
    }

    public <T extends Entity> List<IEntityData<T>> getEntityData(T entity) {
        if (this.registeredEntityData.containsKey(entity)) {
            return this.registeredEntityData.get(entity);
        }
        return new ArrayList<IEntityData<T>>();
    }
}

