/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GlobalPosUtils {
    public static CompoundNBT serializeGlobalPos(GlobalPos globalPos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)globalPos.func_218180_b()));
        tag.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)globalPos.func_218177_a()).toString());
        return tag;
    }

    public static GlobalPos deserializeGlobalPos(CompoundNBT tag) {
        return GlobalPos.func_218179_a((DimensionType)DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tag.func_74779_i("dim"))), (BlockPos)NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos")));
    }

    public static World getWorldForGlobalPos(GlobalPos pos) {
        return DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)pos.func_218177_a(), (boolean)false, (boolean)false);
    }

    public static String prettyPrint(GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        return String.format("%s [%d,%d,%d]", DimensionType.func_212678_a((DimensionType)pos.func_218177_a()), p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
    }

    public static TileEntity getTileEntity(GlobalPos globalPos) {
        World world = GlobalPosUtils.getWorldForGlobalPos(globalPos);
        if (world != null && world.isAreaLoaded(globalPos.func_218180_b(), 1)) {
            return world.func_175625_s(globalPos.func_218180_b());
        }
        return null;
    }
}

