/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncRedstoneModuleToClient
extends LocationIntPacket {
    private ModuleRedstone.EnumRedstoneDirection dir;
    private int outputLevel;
    private int inputLevel;
    private int channel;
    private byte side;

    public PacketSyncRedstoneModuleToClient() {
    }

    public PacketSyncRedstoneModuleToClient(ModuleRedstone module) {
        super(module.getTube().func_174877_v());
        this.dir = module.getRedstoneDirection();
        this.outputLevel = module.getRedstoneLevel();
        this.inputLevel = module.getInputLevel();
        this.channel = module.getColorChannel();
        this.side = (byte)module.getDirection().func_176745_a();
    }

    PacketSyncRedstoneModuleToClient(PacketBuffer buffer) {
        super(buffer);
        this.dir = ModuleRedstone.EnumRedstoneDirection.values()[buffer.readByte()];
        this.side = buffer.readByte();
        this.outputLevel = buffer.readByte();
        this.inputLevel = buffer.readByte();
        this.channel = buffer.readByte();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.dir.ordinal());
        buf.writeByte((int)this.side);
        buf.writeByte(this.outputLevel);
        buf.writeByte(this.inputLevel);
        buf.writeByte(this.channel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TubeModule module;
            TileEntityPressureTube te = TileEntityPressureTube.getTube(ClientUtils.getClientTE(this.pos));
            if (te != null && (module = te.modules[this.side]) instanceof ModuleRedstone) {
                ModuleRedstone mr = (ModuleRedstone)module;
                mr.setColorChannel(this.channel);
                mr.setRedstoneDirection(this.dir);
                mr.setOutputLevel(this.outputLevel);
                mr.setInputLevel(this.inputLevel);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

