/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiMicromissile;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.EntityMicromissile;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMicromissiles
extends Item {
    public static final String NBT_TOP_SPEED = "topSpeed";
    public static final String NBT_TURN_SPEED = "turnSpeed";
    public static final String NBT_DAMAGE = "damage";
    public static final String NBT_FILTER = "filter";
    public static final String NBT_PX = "px";
    public static final String NBT_PY = "py";
    public static final String NBT_FIRE_MODE = "fireMode";

    public ItemMicromissiles() {
        super(ModItems.defaultProps().func_200917_a(1));
    }

    public int getMaxDamage(ItemStack stack) {
        return PNCConfig.Common.Micromissiles.missilePodSize;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                GuiMicromissile.openGui(stack.func_200301_q(), handIn);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        EntityMicromissile missile = new EntityMicromissile(worldIn, (LivingEntity)playerIn, stack);
        Vec3d newPos = missile.func_174791_d().func_178787_e(playerIn.func_70040_Z().func_72432_b());
        missile.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        missile.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.getInitialVelocity(stack), 0.0f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, PNCConfig.Common.Micromissiles.launchCooldown);
        if (!worldIn.field_72995_K) {
            EntityRayTraceResult ertr;
            RayTraceResult res = PneumaticCraftUtils.getMouseOverServer((LivingEntity)playerIn, 100.0);
            if (res instanceof EntityRayTraceResult && missile.isValidTarget((ertr = (EntityRayTraceResult)res).func_216348_a())) {
                missile.setTarget(ertr.func_216348_a());
            }
            worldIn.func_217376_c((Entity)missile);
        }
        if (!playerIn.func_184812_l_()) {
            stack.func_222118_a(1, (LivingEntity)playerIn, playerEntity -> {});
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    private float getInitialVelocity(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            FireMode fireMode = FireMode.fromString(tag.func_74779_i(NBT_FIRE_MODE));
            if (fireMode == FireMode.SMART) {
                return Math.max(0.2f, tag.func_74760_g(NBT_TOP_SPEED) / 2.0f);
            }
            return 0.33333334f;
        }
        return 0.33333334f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        curInfo.add(PneumaticCraftUtils.xlate("gui.micromissile.remaining", stack.func_77958_k() - stack.func_77952_i()));
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            curInfo.add((ITextComponent)new StringTextComponent(" "));
            curInfo.add((ITextComponent)new StringTextComponent(" "));
            curInfo.add((ITextComponent)new StringTextComponent(" "));
            String filter = tag.func_74779_i(NBT_FILTER);
            if (!filter.isEmpty()) {
                curInfo.add(PneumaticCraftUtils.xlate("gui.sentryTurret.targetFilter", filter));
            }
            curInfo.add(PneumaticCraftUtils.xlate("gui.micromissile.firingMode", new Object[0]).func_150258_a(": " + TextFormatting.AQUA).func_150257_a(PneumaticCraftUtils.xlate("gui.micromissile.mode." + tag.func_74779_i(NBT_FIRE_MODE), new Object[0])));
            if (PNCConfig.Common.Micromissiles.damageTerrain) {
                curInfo.add(PneumaticCraftUtils.xlate("gui.tooltip.terrainWarning", new Object[0]));
            } else {
                curInfo.add(PneumaticCraftUtils.xlate("gui.tooltip.terrainSafe", new Object[0]));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        MicromissileDefaults.Entry def;
        if (!stack.func_77942_o() && entityIn instanceof PlayerEntity && (def = MicromissileDefaults.INSTANCE.getDefaults((PlayerEntity)entityIn)) != null) {
            stack.func_77982_d(def.toNBT());
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static enum FireMode {
        SMART,
        DUMB;


        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }
    }
}

