/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;

public class PressureGaugeRenderer3D {
    public static void drawPressureGauge(MatrixStack matrixStack, IRenderTypeBuffer buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(MatrixStack matrixStack, IRenderTypeBuffer buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.TRIANGLE_FAN, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeBackground(posMat, builder, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos));
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoops(2.0), (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeSurround(posMat, builder, xPos, yPos, fgColor));
        int currentScale = (int)maxPressure;
        ArrayList<PressureGaugeRenderer.TextScaler> textScalers = new ArrayList<PressureGaugeRenderer.TextScaler>();
        RenderUtils.renderWithType(matrixStack, buffer, (RenderType)RenderType.field_228614_Q_, (posMat, builder) -> PressureGaugeRenderer3D.drawScale(posMat, builder, minPressure, maxPressure, xPos, yPos, currentScale, textScalers));
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoops(2.0), (posMat, builder) -> {
            double angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
            angleIndicator = -angleIndicator / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            PressureGaugeRenderer3D.drawNeedle(posMat, builder, xPos, yPos, angleIndicator, fgColor);
        });
        PressureGaugeRenderer3D.drawText(matrixStack, buffer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawGaugeBackground(Matrix4f posMat, IVertexBuilder builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = PressureGaugeRenderer.RED;
        RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer.YELLOW : PressureGaugeRenderer.GREEN;
                RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer.GREEN : PressureGaugeRenderer.YELLOW;
                RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorYellow = true;
            }
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            RenderUtils.posF(builder, posMat, Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        }
    }

    private static void drawGaugeSurround(Matrix4f posMat, IVertexBuilder builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        for (int i = 0; i < 500; ++i) {
            double angle = (double)i / 500.0 * 2.0 * Math.PI;
            RenderUtils.posF(builder, posMat, Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }

    private static void drawScale(Matrix4f posMat, IVertexBuilder builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<PressureGaugeRenderer.TextScaler> textScalers) {
        for (int i = 0; i <= 416; ++i) {
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            double x = Math.cos(angle);
            double y = Math.sin(angle);
            textScalers.add(new PressureGaugeRenderer.TextScaler(currentScale, (int)(x * 20.0 * 1.3), (int)(y * 20.0 * 1.3)));
            --currentScale;
            double r1 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 0.8 : 0.92;
            double r2 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 1.15 : 1.08;
            RenderUtils.posF(builder, posMat, x * 20.0 * r1 + (double)xPos, y * 20.0 * r1 + (double)yPos, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            RenderUtils.posF(builder, posMat, x * 20.0 * r2 + (double)xPos, y * 20.0 * r2 + (double)yPos, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
    }

    private static void drawNeedle(Matrix4f posMat, IVertexBuilder builder, int xPos, int yPos, double angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        RenderUtils.posF(builder, posMat, Math.cos(angle + 2.796017461694916) * 20.0 * 0.3 + (double)xPos, Math.sin(angle + 2.796017461694916) * 20.0 * 0.3 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        RenderUtils.posF(builder, posMat, Math.cos(angle + 3.4871678454846706) * 20.0 * 0.3 + (double)xPos, Math.sin(angle + 3.4871678454846706) * 20.0 * 0.3 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        RenderUtils.posF(builder, posMat, Math.cos(angle) * 20.0 * 0.8 + (double)xPos, Math.sin(angle) * 20.0 * 0.8 + (double)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    private static void drawText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int xPos, int yPos, int fgColor, List<PressureGaugeRenderer.TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 11 && i % 5 != 0) continue;
            PressureGaugeRenderer.TextScaler scaler = textScalers.get(i);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(xPos + scaler.x) - 1.5, (double)(yPos + scaler.y) - 1.5, 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            RenderUtils.renderString3d(Integer.toString(scaler.pressure), 0.0f, 0.0f, fgColor, matrixStack, buffer, false, false);
            matrixStack.func_227865_b_();
        }
    }
}

