/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiEntityTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchUpgradeHandler;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    private static final String UPGRADE_NAME = "entityTracker";
    private final Map<Integer, RenderEntityTarget> targets = new HashMap<Integer, RenderEntityTarget>();
    private boolean shouldStopSpamOnEntityTracking = false;
    @OnlyIn(value=Dist.CLIENT)
    private WidgetAnimatedStat entityTrackInfo;
    @Nonnull
    private EntityFilter entityFilter = new EntityFilter("");

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getUpgradeID() {
        return UPGRADE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tick(PlayerEntity player, int rangeUpgrades) {
        EntityFilter newFilter;
        ItemStack helmetStack;
        String filterStr;
        SearchUpgradeHandler searchHandler = HUDHandler.instance().getSpecificRenderer(SearchUpgradeHandler.class);
        if (searchHandler != null && (Minecraft.func_71410_x().field_71441_e.func_82737_E() & 0xFL) == 0L) {
            searchHandler.trackItemEntities(player, rangeUpgrades, WidgetKeybindCheckBox.isHandlerEnabled(searchHandler));
        }
        String string = filterStr = (helmetStack = player.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() ? "" : ItemPneumaticArmor.getEntityFilter(helmetStack);
        if (!this.entityFilter.toString().equals(filterStr) && (newFilter = EntityFilter.fromString(filterStr)) != null) {
            this.entityFilter = newFilter;
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 5);
        AxisAlignedBB bbBox = EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades);
        List entities = player.field_70170_p.func_175647_a(Entity.class, bbBox, (Predicate)((Object)new EntityTrackerSelector(player, this.entityFilter, entityTrackRange)));
        for (Object entity : entities) {
            RenderEntityTarget renderEntityTarget = this.targets.get(entity.func_145782_y());
            if (renderEntityTarget != null) {
                renderEntityTarget.ticksExisted = Math.abs(renderEntityTarget.ticksExisted);
                continue;
            }
            this.targets.put(entity.func_145782_y(), new RenderEntityTarget((Entity)entity));
        }
        ArrayList toRemove = new ArrayList();
        for (Map.Entry entry : this.targets.entrySet()) {
            RenderEntityTarget target = (RenderEntityTarget)entry.getValue();
            if (target.entity.func_70089_S() && !((double)player.func_70032_d(target.entity) > entityTrackRange + 5.0) && this.entityFilter.test(target.entity)) continue;
            if (target.ticksExisted > 0) {
                target.ticksExisted = -60;
                continue;
            }
            if (target.ticksExisted != -1) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.targets::remove);
        if (this.targets.size() > 7) {
            if (!this.shouldStopSpamOnEntityTracking) {
                this.shouldStopSpamOnEntityTracking = true;
                HUDHandler.instance().addMessage(new ArmorMessage("Stopped spam on Entity Tracker", new ArrayList<String>(), 60, 0x7700AA00));
            }
        } else {
            this.shouldStopSpamOnEntityTracking = false;
        }
        ArrayList<String> text = new ArrayList<String>();
        for (RenderEntityTarget target : this.targets.values()) {
            boolean wasNegative = target.ticksExisted < 0;
            target.ticksExisted += CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EquipmentSlotType.HEAD);
            if (target.ticksExisted >= 0 && wasNegative) {
                target.ticksExisted = -1;
            }
            target.update();
            if (!target.isLookingAtTarget) continue;
            if (target.isInitialized()) {
                text.add(TextFormatting.GRAY + target.entity.func_145748_c_().func_150254_d());
                text.addAll(target.getEntityText());
                continue;
            }
            text.add(TextFormatting.GRAY + "Acquiring target...");
        }
        if (text.size() == 0) {
            text.add("Filter mode: " + (this.entityFilter.toString().isEmpty() ? "None" : this.entityFilter.toString()));
        }
        this.entityTrackInfo.setText(text);
    }

    static AxisAlignedBB getAABBFromRange(PlayerEntity player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(10, rangeUpgrades) * 5);
        return new AxisAlignedBB(player.func_180425_c()).func_186662_g(entityTrackRange);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        this.targets.values().forEach(target -> target.render(matrixStack, buffer, partialTicks, this.shouldStopSpamOnEntityTracking));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.ENTITY_TRACKER};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void reset() {
        this.targets.clear();
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, PlayerEntity player) {
        return 1.0f * (1.0f + (float)Math.min(10, rangeUpgrades) * 5.0f / 16.0f) * (float)CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EquipmentSlotType.HEAD);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiEntityTrackOptions(screen, this);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.ENTITY_TRACKER.getItemStack());
            this.entityTrackInfo = new WidgetAnimatedStat(null, "Current tracked entities:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.entityTrackerStat);
            this.entityTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.entityTrackInfo;
    }

    public Stream<RenderEntityTarget> getTargetsStream() {
        return this.targets.values().stream();
    }

    public RenderEntityTarget getTargetForEntity(Entity entity) {
        return this.getTargetsStream().filter(target -> target.entity == entity).findFirst().orElse(null);
    }

    public void hack() {
        this.getTargetsStream().forEach(RenderEntityTarget::hack);
    }

    public void selectAsDebuggingTarget() {
        this.getTargetsStream().forEach(RenderEntityTarget::selectAsDebuggingTarget);
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        return this.getTargetsStream().anyMatch(target -> target.scroll(event));
    }

    @Override
    public void onResolutionChanged() {
        this.entityTrackInfo = null;
    }

    private static class EntityTrackerSelector
    extends StringFilterEntitySelector {
        private final PlayerEntity player;
        private final double threshold;

        private EntityTrackerSelector(PlayerEntity player, EntityFilter filter, double threshold) {
            this.player = player;
            this.threshold = threshold;
            this.setFilter(Collections.singletonList(filter));
        }

        @Override
        public boolean apply(Entity entity) {
            return entity != this.player && (entity instanceof LivingEntity || entity instanceof HangingEntity) && entity.func_70089_S() && (double)this.player.func_70032_d(entity) < this.threshold && !MinecraftForge.EVENT_BUS.post((Event)new EntityTrackEvent(entity)) && super.apply(entity);
        }
    }
}

