/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;

public class WidgetCheckBox
extends Widget
implements ITaggedWidget,
ITooltipProvider {
    public boolean checked;
    private final int color;
    private List<String> tooltip = new ArrayList<String>();
    private final Consumer<WidgetCheckBox> pressable;
    private static final int CHECKBOX_WIDTH = 10;
    private static final int CHECKBOX_HEIGHT = 10;
    private String tag = null;

    public WidgetCheckBox(int x, int y, int color, String text, Consumer<WidgetCheckBox> pressable) {
        super(x, y, 13 + Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)text, (Object[])new Object[0])), 10, text);
        this.x = x;
        this.y = y;
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetCheckBox(int x, int y, int color, String text) {
        this(x, y, color, text, null);
    }

    public WidgetCheckBox withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            WidgetCheckBox.fill((int)this.x, (int)this.y, (int)(this.x + 10), (int)(this.y + 10), (int)(this.active ? -6250336 : -6710887));
            WidgetCheckBox.fill((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + 10 - 1), (int)(this.y + 10 - 1), (int)(this.active ? -14671840 : -5592406));
            if (this.checked) {
                RenderSystem.disableTexture();
                if (this.active) {
                    RenderSystem.color4f((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                }
                BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
                RenderSystem.lineWidth((float)2.0f);
                wr.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                wr.func_225582_a_((double)(this.x + 2), (double)(this.y + 5), 0.0).func_181675_d();
                wr.func_225582_a_((double)(this.x + 5), (double)(this.y + 7), 0.0).func_181675_d();
                wr.func_225582_a_((double)(this.x + 8), (double)(this.y + 3), 0.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.enableTexture();
                RenderSystem.color4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String string = I18n.func_135052_a((String)this.getMessage(), (Object[])new Object[0]);
            float f = this.x + 3 + 10;
            float f2 = (float)this.y + 5.0f;
            fr.getClass();
            fr.func_211126_b(string, f, f2 - 9.0f / 2.0f, this.active ? this.color : -7829368);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.active) {
            boolean bl = this.checked = !this.checked;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            if (this.tag != null) {
                NetworkHandler.sendToServer(new PacketGuiButton(this.tag));
            }
        }
    }

    public WidgetCheckBox setTooltip(String tooltip) {
        this.tooltip.clear();
        if (tooltip != null && !tooltip.equals("")) {
            this.tooltip.add(tooltip);
        }
        return this;
    }

    public WidgetCheckBox setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public WidgetCheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public String getTooltip() {
        return this.tooltip.size() > 0 ? this.tooltip.get(0) : "";
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        curTip.addAll(this.tooltip);
    }
}

