/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class AmadronTradeResource {
    private final Type type;
    private final ItemStack item;
    private final FluidStack fluid;

    private AmadronTradeResource(@Nonnull ItemStack stack) {
        this.item = stack;
        this.type = Type.ITEM;
        this.fluid = FluidStack.EMPTY;
    }

    private AmadronTradeResource(@Nonnull FluidStack stack) {
        this.item = ItemStack.field_190927_a;
        this.type = Type.FLUID;
        this.fluid = stack;
    }

    public boolean equivalentTo(AmadronTradeResource other) {
        if (this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case ITEM: {
                return this.getItem().func_77973_b() == other.getItem().func_77973_b();
            }
            case FLUID: {
                return this.getFluid().getFluid() == other.getFluid().getFluid();
            }
        }
        return false;
    }

    public static AmadronTradeResource of(ItemStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource of(FluidStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource fromPacketBuf(PacketBuffer pb) {
        Type type = Type.values()[pb.readByte()];
        switch (type) {
            case ITEM: {
                return new AmadronTradeResource(pb.func_150791_c());
            }
            case FLUID: {
                return new AmadronTradeResource(FluidStack.loadFluidStackFromNBT((CompoundNBT)pb.func_150793_b()));
            }
        }
        throw new IllegalStateException("bad trade resource type: " + (Object)((Object)type));
    }

    public Type getType() {
        return this.type;
    }

    public ItemStack getItem() {
        return this.type == Type.ITEM ? this.item : ItemStack.field_190927_a;
    }

    public FluidStack getFluid() {
        return this.type == Type.FLUID ? this.fluid : FluidStack.EMPTY;
    }

    public int countTradesInInventory(LazyOptional<IItemHandler> inv) {
        return AmadronTradeResource.countItemsInHandler(this.item, inv) / this.item.func_190916_E();
    }

    public int findSpaceInItemOutput(LazyOptional<IItemHandler> inv, int wantedTradeCount) {
        return Math.min(wantedTradeCount, AmadronTradeResource.findSpaceInHandler(this.item, wantedTradeCount, inv));
    }

    public int countTradesInTank(LazyOptional<IFluidHandler> lazy) {
        return (Integer)lazy.map(fluidHandler -> {
            FluidStack searchingFluid = this.fluid.copy();
            searchingFluid.setAmount(Integer.MAX_VALUE);
            FluidStack extracted = fluidHandler.drain(searchingFluid, IFluidHandler.FluidAction.SIMULATE);
            return extracted.getAmount() / this.fluid.getAmount();
        }).orElse((Object)0);
    }

    public int findSpaceInFluidOutput(LazyOptional<IFluidHandler> lazy, int wantedTradeCount) {
        return (Integer)lazy.map(fluidHandler -> {
            FluidStack providingFluid = this.fluid.copy();
            providingFluid.setAmount(providingFluid.getAmount() * wantedTradeCount);
            int amountFilled = fluidHandler.fill(providingFluid, IFluidHandler.FluidAction.SIMULATE);
            return amountFilled / this.fluid.getAmount();
        }).orElse((Object)0);
    }

    public AmadronTradeResource validate() {
        Validate.isTrue((this.item != null && this.fluid != null ? 1 : 0) != 0);
        switch (this.type) {
            case ITEM: {
                Validate.isTrue((this.item != null && !this.item.func_190926_b() ? 1 : 0) != 0);
                break;
            }
            case FLUID: {
                Validate.isTrue((this.fluid != null && !this.fluid.isEmpty() ? 1 : 0) != 0);
            }
        }
        return this;
    }

    public static AmadronTradeResource fromJson(JsonObject obj) throws CommandSyntaxException {
        Type type = Type.valueOf(obj.get("type").getAsString().toUpperCase());
        ResourceLocation rl = new ResourceLocation(obj.get("id").getAsString());
        int amount = obj.get("amount").getAsInt();
        switch (type) {
            case ITEM: {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                ItemStack stack = new ItemStack((IItemProvider)item, amount);
                if (obj.has("nbt")) {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)obj, (String)"nbt")));
                }
                return new AmadronTradeResource(stack);
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                FluidStack fluidStack = new FluidStack(fluid, amount);
                return new AmadronTradeResource(fluidStack);
            }
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject res = new JsonObject();
        res.addProperty("type", this.type.name());
        switch (this.type) {
            case ITEM: {
                ResourceLocation name = this.item.func_77973_b().getRegistryName();
                res.addProperty("id", name == null ? "" : name.toString());
                res.addProperty("amount", (Number)this.item.func_190916_E());
                if (!this.item.func_77942_o()) break;
                res.addProperty("nbt", this.item.func_77978_p().toString());
                break;
            }
            case FLUID: {
                res.addProperty("id", this.fluid.getFluid().getRegistryName().toString());
                res.addProperty("amount", (Number)this.fluid.getAmount());
            }
        }
        return res;
    }

    public void writeToBuf(PacketBuffer pb) {
        pb.writeByte(this.type.ordinal());
        switch (this.type) {
            case ITEM: {
                pb.func_150788_a(this.item);
                break;
            }
            case FLUID: {
                pb.func_150786_a(this.fluid.writeToNBT(new CompoundNBT()));
            }
        }
    }

    public String getName() {
        switch (this.type) {
            case ITEM: {
                return this.item.func_200301_q().func_150254_d();
            }
            case FLUID: {
                return this.fluid.getDisplayName().func_150254_d();
            }
        }
        return null;
    }

    public int getAmount() {
        switch (this.type) {
            case ITEM: {
                return this.item.func_190916_E();
            }
            case FLUID: {
                return this.fluid.getAmount();
            }
        }
        return 0;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("type", this.type.toString());
        CompoundNBT subTag = this.type == Type.ITEM ? this.item.func_77955_b(new CompoundNBT()) : this.fluid.writeToNBT(new CompoundNBT());
        tag.func_218657_a("resource", (INBT)subTag);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronTradeResource)) {
            return false;
        }
        AmadronTradeResource that = (AmadronTradeResource)o;
        return this.type == Type.ITEM && ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)that.item) || this.type == Type.FLUID && this.fluid.equals((Object)that.fluid) && this.fluid.getAmount() == that.fluid.getAmount();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.item, this.fluid});
    }

    public String toString() {
        switch (this.type) {
            case ITEM: {
                return this.item.func_190916_E() + " x " + this.item.func_200301_q().func_150254_d();
            }
            case FLUID: {
                return this.fluid.getAmount() + "mB " + this.fluid.getDisplayName().func_150254_d();
            }
        }
        return super.toString();
    }

    private static int countItemsInHandler(ItemStack item, LazyOptional<IItemHandler> lazy) {
        boolean matchNBT = item.func_77942_o();
        return (Integer)lazy.map(handler -> IntStream.range(0, handler.getSlots()).filter(i -> PneumaticCraftUtils.doesItemMatchFilter(item, handler.getStackInSlot(i), false, matchNBT, false)).map(i -> handler.getStackInSlot(i).func_190916_E()).sum()).orElse((Object)0);
    }

    private static int findSpaceInHandler(ItemStack item, int multiplier, LazyOptional<IItemHandler> lazy) {
        int totalItems = item.func_190916_E() * multiplier;
        return (Integer)lazy.map(inv -> {
            int remaining = totalItems;
            for (int i = 0; i < inv.getSlots() && remaining > 0; ++i) {
                if (!inv.getStackInSlot(i).func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)item)) continue;
                remaining -= item.func_77976_d() - inv.getStackInSlot(i).func_190916_E();
            }
            return (totalItems - remaining) / item.func_190916_E();
        }).orElse((Object)0);
    }

    public static enum Type {
        ITEM,
        FLUID;

    }
}

