/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileIncensePlate;

public class BlockIncensePlate
extends BlockMod {
    private static final VoxelShape X_SHAPE = BlockIncensePlate.func_208617_a((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)1.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = BlockIncensePlate.func_208617_a((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0);

    protected BlockIncensePlate(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileIncensePlate plate = (TileIncensePlate)world.func_175625_s(pos);
        ItemStack plateStack = plate.getItemHandler().getStackInSlot(0);
        ItemStack stack = player.func_184586_b(hand);
        boolean did = false;
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (plateStack.func_190926_b() && plate.acceptsItem(stack)) {
            plate.getItemHandler().setStackInSlot(0, stack.func_77946_l());
            stack.func_190918_g(1);
            did = true;
        } else if (!plateStack.func_190926_b() && !plate.burning) {
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
                plate.ignite();
                stack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
                did = true;
            } else {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)plateStack);
                plate.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
                did = true;
            }
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
        return did ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return ((TileIncensePlate)world.func_175625_s((BlockPos)pos)).comparatorOutput;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        if (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == Direction.Axis.X) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileIncensePlate();
    }
}

