/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketUpdateItemsRemaining;

public final class ItemsRemainingRenderHandler {
    private static final int maxTicks = 30;
    private static final int leaveTicks = 20;
    private static ItemStack stack = ItemStack.field_190927_a;
    @Nullable
    private static ITextComponent customString;
    private static int ticks;
    private static int count;

    @OnlyIn(value=Dist.CLIENT)
    public static void render(float partTicks) {
        if (ticks > 0 && !stack.func_190926_b()) {
            int pos = 30 - ticks;
            Minecraft mc = Minecraft.func_71410_x();
            int x = mc.func_228018_at_().func_198107_o() / 2 + 10 + Math.max(0, pos - 20);
            int y = mc.func_228018_at_().func_198087_p() / 2;
            int start = 10;
            float alpha = (float)ticks + partTicks > (float)start ? 1.0f : ((float)ticks + partTicks) / (float)start;
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.enableRescaleNormal();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int xp = x + (int)(16.0f * (1.0f - alpha));
            RenderSystem.translatef((float)xp, (float)y, (float)0.0f);
            RenderSystem.scalef((float)alpha, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_180450_b(stack, 0, 0);
            RenderSystem.scalef((float)(1.0f / alpha), (float)1.0f, (float)1.0f);
            RenderSystem.translatef((float)(-xp), (float)(-y), (float)0.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            String text = "";
            if (customString == null) {
                if (!stack.func_190926_b()) {
                    text = TextFormatting.GREEN + stack.func_200301_q().getString();
                    if (count >= 0) {
                        int max = stack.func_77976_d();
                        int stacks = count / max;
                        int rem = count % max;
                        text = stacks == 0 ? "" + count : count + " (" + TextFormatting.AQUA + stacks + TextFormatting.RESET + "*" + TextFormatting.GRAY + max + TextFormatting.RESET + "+" + TextFormatting.YELLOW + rem + TextFormatting.RESET + ")";
                    } else if (count == -1) {
                        text = "\u221e";
                    }
                }
            } else {
                text = customString.func_150254_d();
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.field_71466_p.func_175063_a(text, (float)(x + 20), (float)(y + 6), color);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        if (ticks > 0) {
            --ticks;
        }
    }

    public static void send(PlayerEntity player, ItemStack stack, int count) {
        ItemsRemainingRenderHandler.send(player, stack, count, null);
    }

    public static void set(ItemStack stack, int count, @Nullable ITextComponent str) {
        ItemsRemainingRenderHandler.stack = stack;
        ItemsRemainingRenderHandler.count = count;
        customString = str;
        ticks = stack.func_190926_b() ? 0 : 30;
    }

    public static void send(PlayerEntity entity, ItemStack stack, int count, @Nullable ITextComponent str) {
        PacketHandler.sendTo((ServerPlayerEntity)entity, new PacketUpdateItemsRemaining(stack, count, str));
    }

    public static void send(PlayerEntity player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !pattern.matcher(stack.func_77977_a()).find()) continue;
            count += stack.func_190916_E();
        }
        ItemsRemainingRenderHandler.send(player, displayStack, count, null);
    }
}

