/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FakeMob {
    private static final String INVALID_ENTITY_KEY = "INVALID";
    private static final String EMPTY_TAG = "";
    private String entityKey;
    private String tag;
    private String name;
    private static final String KEY_ENTITY = "keyEntity";
    private static final String KEY_TAG = "keyTag";
    private static final String CHARGED_TAG = "charged";
    private static final String SMALL_TAG = "small";
    private static final String LARGE_TAG = "large";
    private static final String CREEPER = "minecraft:creeper";
    private static final String SLIME = "minecraft:slime";
    private static final String MAGMA_CUBE = "minecraft:magma_cube";
    private static final String ENDER_DRAGON = "minecraft:ender_dragon";
    private static final String WITHER = "minecraft:wither";

    public FakeMob() {
        this(INVALID_ENTITY_KEY, EMPTY_TAG);
    }

    public FakeMob(String s) {
        this();
        String[] parts = s.split(Pattern.quote(","));
        if (parts.length == 1) {
            this.setInfo(s, EMPTY_TAG);
        } else if (parts.length == 2) {
            this.setInfo(parts[0], parts[1]);
        }
    }

    private FakeMob(String entityKey, String tag) {
        this.setInfo(entityKey, tag);
    }

    public FakeMob(FakeMob fakeMob) {
        this(fakeMob.getEntityKey(), fakeMob.getTag());
    }

    public FakeMob(MobEntity mobEntity) {
        this();
        if (this.isSlime(mobEntity)) {
            if (((SlimeEntity)mobEntity).func_189101_db()) {
                this.setInfo(mobEntity.func_70022_Q(), SMALL_TAG);
            } else {
                this.setInfo(mobEntity.func_70022_Q(), LARGE_TAG);
            }
        } else if (this.isMagmaCube(mobEntity)) {
            if (((MagmaCubeEntity)mobEntity).func_189101_db()) {
                this.setInfo(mobEntity.func_70022_Q(), SMALL_TAG);
            } else {
                this.setInfo(mobEntity.func_70022_Q(), LARGE_TAG);
            }
        } else if (this.isChargedCreeper(mobEntity)) {
            this.setInfo(mobEntity.func_70022_Q(), CHARGED_TAG);
        } else {
            this.setInfo(mobEntity.func_70022_Q(), EMPTY_TAG);
        }
    }

    private void setInfo(String entityKey, String tag) {
        this.entityKey = entityKey;
        this.tag = tag;
        this.name = entityKey;
        if (!this.tag.equalsIgnoreCase(EMPTY_TAG)) {
            this.name = this.name + "," + this.tag;
        }
    }

    public String toString() {
        return this.name;
    }

    private String getEntityKey() {
        return this.entityKey;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTag() {
        return !this.tag.equalsIgnoreCase(EMPTY_TAG);
    }

    @Nonnull
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.entityKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeMob fakeMob = (FakeMob)o;
        return this.entityKey.equalsIgnoreCase(fakeMob.entityKey) && this.tag.equalsIgnoreCase(fakeMob.tag) && this.name.equalsIgnoreCase(fakeMob.name);
    }

    public int hashCode() {
        return Objects.hash(this.entityKey, this.tag, this.name);
    }

    public boolean isValid() {
        return !this.entityKey.equalsIgnoreCase(INVALID_ENTITY_KEY);
    }

    public static boolean isInEntityList(FakeMob fakeMob) {
        return ForgeRegistries.ENTITIES.containsKey(fakeMob.getResourceLocation());
    }

    public static void writeToNBT(@Nonnull FakeMob fakeMob, CompoundNBT nbtTagCompound) {
        if (fakeMob.isValid()) {
            if (nbtTagCompound == null) {
                nbtTagCompound = new CompoundNBT();
            }
            nbtTagCompound.func_74778_a(KEY_ENTITY, fakeMob.entityKey);
            nbtTagCompound.func_74778_a(KEY_TAG, fakeMob.tag);
        }
    }

    public FakeMob(CompoundNBT nbtTagCompound) {
        this();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b(KEY_ENTITY) && nbtTagCompound.func_74764_b(KEY_TAG)) {
            this.setInfo(nbtTagCompound.func_74779_i(KEY_ENTITY), nbtTagCompound.func_74779_i(KEY_TAG));
        }
    }

    private boolean isChargedCreeper(MobEntity mobEntity) {
        return mobEntity instanceof CreeperEntity && ((CreeperEntity)mobEntity).func_225509_J__();
    }

    private boolean isSlime(MobEntity mobEntity) {
        return mobEntity instanceof SlimeEntity;
    }

    private boolean isMagmaCube(MobEntity mobEntity) {
        return mobEntity instanceof MagmaCubeEntity;
    }

    public boolean isChargedCreeper() {
        return this.getEntityKey().equalsIgnoreCase(CREEPER) && this.tag.equalsIgnoreCase(CHARGED_TAG);
    }

    public boolean isSmallSlime() {
        return this.getEntityKey().equalsIgnoreCase(SLIME) && this.tag.equalsIgnoreCase(SMALL_TAG);
    }

    public boolean isSmallMagmaCube() {
        return this.getEntityKey().equalsIgnoreCase(MAGMA_CUBE) && this.tag.equalsIgnoreCase(SMALL_TAG);
    }

    public static FakeMob getEnderDragon() {
        return new FakeMob(ENDER_DRAGON);
    }

    public static FakeMob getWither() {
        return new FakeMob(WITHER);
    }
}

