/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.tartarus;

import ipsis.woot.Woot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;

public class TartarusChunkGenerator
extends ChunkGenerator<Config> {
    private static final int WORK_CHUNK_X = 0;
    private static final int WORK_CHUNK_Z = 0;
    private List<BlockPos> cell0Blocks;
    private List<BlockPos> cell1Blocks;
    private List<BlockPos> cell2Blocks;
    private List<BlockPos> cell3Blocks;

    public TartarusChunkGenerator(IWorld world, BiomeProvider biomeProvider) {
        super(world, biomeProvider, (GenerationSettings)Config.createDefault());
    }

    private void calcCellStructures() {
        if (this.cell1Blocks != null) {
            return;
        }
        ArrayList<BlockPos> fullBlocks = new ArrayList<BlockPos>(512);
        for (int x = 0; x < 8; ++x) {
            for (int z = 0; z < 8; ++z) {
                for (int y = 0; y < 8; ++y) {
                    fullBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        ArrayList<BlockPos> innerBlocks = new ArrayList<BlockPos>(512);
        for (int x = 1; x < 7; ++x) {
            for (int z = 1; z < 7; ++z) {
                for (int y = 1; y < 7; ++y) {
                    innerBlocks.add(new BlockPos(x, y, z));
                }
            }
        }
        this.cell0Blocks = new ArrayList<BlockPos>();
        for (BlockPos p : fullBlocks) {
            if (innerBlocks.contains(p)) continue;
            this.cell0Blocks.add(new BlockPos((Vec3i)p));
        }
        this.cell1Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell1Blocks.add(new BlockPos(p.func_177958_n() + 8, p.func_177956_o(), p.func_177952_p()));
        }
        this.cell2Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell2Blocks.add(new BlockPos(p.func_177958_n() + 8, p.func_177956_o(), p.func_177952_p() + 8));
        }
        this.cell3Blocks = new ArrayList<BlockPos>(this.cell0Blocks.size());
        for (BlockPos p : this.cell0Blocks) {
            this.cell3Blocks.add(new BlockPos(p.func_177958_n(), p.func_177956_o(), p.func_177952_p() + 8));
        }
        fullBlocks = null;
        innerBlocks = null;
    }

    private void buildCell(IChunk iChunk, List<BlockPos> posList, int y, BlockState blockState) {
        for (BlockPos pos : posList) {
            iChunk.func_177436_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + y, pos.func_177952_p()), blockState, false);
        }
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk) {
        Woot.setup.getLogger().info("generateSurface: {}", (Object)iChunk);
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x1 = 0; x1 < 16; ++x1) {
            for (int z1 = 0; z1 < 16; ++z1) {
                for (int y1 = 0; y1 < 256; ++y1) {
                    iChunk.func_177436_a((BlockPos)pos.func_181079_c(x1, y1, z1), blockState, false);
                }
            }
        }
        if (iChunk.func_76632_l().field_77276_a == 0 && iChunk.func_76632_l().field_77275_b == 0) {
            Woot.setup.getLogger().info("generateSurface: work chunk creating cells");
            BlockState wallState = Blocks.field_150359_w.func_176223_P();
            this.calcCellStructures();
            for (int y = 0; y < 256; y += 8) {
                this.buildCell(iChunk, this.cell0Blocks, y, wallState);
                this.buildCell(iChunk, this.cell1Blocks, y, wallState);
                this.buildCell(iChunk, this.cell2Blocks, y, wallState);
                this.buildCell(iChunk, this.cell3Blocks, y, wallState);
            }
        }
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public void func_222537_b(IWorld iWorld, IChunk iChunk) {
    }

    public int func_222529_a(int i, int i1, Heightmap.Type type) {
        return 0;
    }

    public static class Config
    extends GenerationSettings {
        public static Config createDefault() {
            Config config = new Config();
            return config;
        }
    }
}

