/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.spawning;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.simulator.spawning.CustomSpawnController;
import ipsis.woot.simulator.spawning.FakePlayerPool;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnController {
    static SpawnController INSTANCE = new SpawnController();
    Map<String, Integer> mobHealthCache = new HashMap<String, Integer>();
    Map<String, Integer> mobXpCache = new HashMap<String, Integer>();

    public static SpawnController get() {
        return INSTANCE;
    }

    public void spawnKill(@Nonnull FakeMobKey fakeMobKey, @Nonnull World world, @Nonnull BlockPos spawnPos) {
        if (!fakeMobKey.getMob().isValid()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((ServerWorld)world, fakeMobKey.getLooting());
        if (fakePlayer == null) {
            return;
        }
        Entity entity = this.createEntity(fakeMobKey.getMob(), world, spawnPos);
        if (entity == null || !(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        mobEntity.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos(entity)), SpawnReason.SPAWNER, null, null);
        mobEntity.field_70718_bc = 100;
        mobEntity.field_70717_bb = fakePlayer;
        CustomSpawnController.get().apply(mobEntity, fakeMobKey.getMob(), world);
        mobEntity.func_70645_a(DamageSource.func_76365_a((PlayerEntity)fakePlayer));
    }

    @Nullable
    private Entity createEntity(@Nonnull FakeMob fakeMob, @Nonnull World world, @Nonnull BlockPos pos) {
        ResourceLocation rl = fakeMob.getResourceLocation();
        if (!ForgeRegistries.ENTITIES.containsKey(rl)) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", rl.toString());
        Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)world, xc -> {
            xc.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), xc.field_70177_z, xc.field_70125_A);
            return xc;
        });
        return entity;
    }

    public int getMobHealth(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        if (world.field_72995_K) {
            return -1;
        }
        if (!fakeMob.isValid()) {
            return -1;
        }
        if (!this.isCached(fakeMob)) {
            this.updateCache(fakeMob, world);
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.HEALTH)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.HEALTH);
        }
        String key = fakeMob.toString();
        return this.mobHealthCache.get(key);
    }

    public int getMobExperience(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        if (world.field_72995_K) {
            return -1;
        }
        if (!fakeMob.isValid()) {
            return -1;
        }
        if (!this.isCached(fakeMob)) {
            this.updateCache(fakeMob, world);
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.XP)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.XP);
        }
        String key = fakeMob.toString();
        return this.mobXpCache.get(key);
    }

    private boolean isCached(@Nonnull FakeMob fakeMob) {
        return this.mobHealthCache.containsKey(fakeMob.toString());
    }

    private void updateCache(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        if (entity == null || !(entity instanceof LivingEntity)) {
            return;
        }
        int health = (int)((LivingEntity)entity).func_110138_aP();
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((ServerWorld)world, 0);
        int xp = 1;
        try {
            Method getExp = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70693_a", (Class[])new Class[]{PlayerEntity.class});
            getExp.setAccessible(true);
            xp = (Integer)getExp.invoke((Object)entity, fakePlayer);
        }
        catch (Throwable e) {
            Woot.setup.getLogger().debug("Reflection of getExperiencePoints failed {}", e);
        }
        String key = fakeMob.toString();
        this.mobHealthCache.put(key, health);
        this.mobXpCache.put(key, xp);
    }

    public boolean isLivingEntity(FakeMob fakeMob, World world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        return entity != null && entity instanceof MobEntity;
    }
}

