/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.spawning;

import com.mojang.authlib.GameProfile;
import ipsis.woot.Woot;
import ipsis.woot.util.helper.MathHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class FakePlayerPool {
    private static final String LOOT_0 = "[woot_0]";
    private static final String LOOT_1 = "[woot_1]";
    private static final String LOOT_2 = "[woot_2]";
    private static final String LOOT_3 = "[woot_3]";
    private static final GameProfile GP_LOOT_0 = new GameProfile(UUID.nameUUIDFromBytes("[woot_0]".getBytes()), "[woot_0]");
    private static final GameProfile GP_LOOT_1 = new GameProfile(UUID.nameUUIDFromBytes("[woot_1]".getBytes()), "[woot_1]");
    private static final GameProfile GP_LOOT_2 = new GameProfile(UUID.nameUUIDFromBytes("[woot_2]".getBytes()), "[woot_2]");
    private static final GameProfile GP_LOOT_3 = new GameProfile(UUID.nameUUIDFromBytes("[woot_3]".getBytes()), "[woot_3]");
    private static Map<Integer, FakePlayer> fakePlayerMap;

    private static void addFakePlayer(@Nonnull FakePlayer fakePlayer, int looting, Enchantment enchantment) {
        ItemStack sword = new ItemStack((IItemProvider)Items.field_151048_u);
        if (looting > 0 && enchantment != null) {
            sword.func_77966_a(enchantment, looting);
        }
        fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, sword);
        fakePlayerMap.put(looting, fakePlayer);
    }

    private static void init(@Nonnull ServerWorld world) {
        fakePlayerMap = new HashMap<Integer, FakePlayer>();
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("minecraft", "looting"));
        if (enchantment == null) {
            Woot.setup.getLogger().warn("FakePlayerPool failed to find looting enchantment");
        }
        FakePlayerPool.addFakePlayer(FakePlayerFactory.get((ServerWorld)world, (GameProfile)GP_LOOT_0), 0, enchantment);
        FakePlayerPool.addFakePlayer(FakePlayerFactory.get((ServerWorld)world, (GameProfile)GP_LOOT_1), 1, enchantment);
        FakePlayerPool.addFakePlayer(FakePlayerFactory.get((ServerWorld)world, (GameProfile)GP_LOOT_2), 2, enchantment);
        FakePlayerPool.addFakePlayer(FakePlayerFactory.get((ServerWorld)world, (GameProfile)GP_LOOT_3), 3, enchantment);
    }

    @Nullable
    public static FakePlayer getFakePlayer(@Nonnull ServerWorld world, int looting) {
        if (fakePlayerMap == null) {
            FakePlayerPool.init(world);
        }
        return fakePlayerMap.get(MathHelper.clampLooting(looting));
    }

    public static boolean isFakePlayer(@Nonnull Entity entity) {
        if (!(entity instanceof FakePlayer)) {
            return false;
        }
        FakePlayer fp = (FakePlayer)entity;
        UUID uuid = fp.func_110124_au();
        return GP_LOOT_0.getId().equals(uuid) || GP_LOOT_1.getId().equals(uuid) || GP_LOOT_2.getId().equals(uuid) || GP_LOOT_3.getId().equals(uuid);
    }
}

