/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.crafting.DyeSqueezerRecipe;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerContainer;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootEnergyStorage;
import ipsis.woot.util.WootFluidTank;
import ipsis.woot.util.WootMachineTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DyeSqueezerTileEntity
extends WootMachineTileEntity
implements WootDebug,
INamedContainerProvider {
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    public final IItemHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DyeSqueezerTileEntity.this.onContentsChanged(slot);
            DyeSqueezerTileEntity.this.func_70296_d();
        }

        public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? DyeSqueezerRecipe.isValidInput(stack) : false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private LazyOptional<WootFluidTank> outputTank = LazyOptional.of(this::createTank);
    private LazyOptional<WootEnergyStorage> energyStorage = LazyOptional.of(this::createEnergy);
    public static int INPUT_SLOT = 0;
    private final LazyOptional<IItemHandler> inventoryGetter = LazyOptional.of(() -> this.inventory);
    private DyeSqueezerRecipe currRecipe = null;

    public DyeSqueezerTileEntity() {
        super((TileEntityType)SqueezerSetup.SQUEEZER_BLOCK_TILE.get());
    }

    public void onLoad() {
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, WootMachineTileEntity.Mode.OUTPUT);
        }
    }

    private WootFluidTank createTank() {
        return new WootFluidTank((Integer)SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get(), h -> h.isFluidEqual(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 1))).setAccess(false, true);
    }

    public FluidStack getOutputTankFluid() {
        return (FluidStack)this.outputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
    }

    private WootEnergyStorage createEnergy() {
        return new WootEnergyStorage((Integer)SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY.get(), (Integer)SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY_RX.get());
    }

    public int getEnergy() {
        return (Integer)this.energyStorage.map(h -> h.getEnergyStored()).orElse((Object)0);
    }

    public void setEnergy(int v) {
        this.energyStorage.ifPresent(h -> h.setEnergy(v));
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_150297_b("InputInventory", 9)) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inventory, null, (INBT)compoundNBT.func_150295_c("InputInventory", 10));
        }
        CompoundNBT tankTag = compoundNBT.func_74775_l("OutputTank");
        this.outputTank.ifPresent(h -> h.readFromNBT(tankTag));
        CompoundNBT energyTag = compoundNBT.func_74775_l("Energy");
        this.energyStorage.ifPresent(h -> h.deserializeNBT((INBT)energyTag));
        if (compoundNBT.func_74764_b("InternalTanks")) {
            CompoundNBT dyeTag = compoundNBT.func_74775_l("InternalTanks");
            this.red = dyeTag.func_74762_e("Red");
            this.yellow = dyeTag.func_74762_e("Yellow");
            this.blue = dyeTag.func_74762_e("Blue");
            this.white = dyeTag.func_74762_e("White");
        }
        super.func_145839_a(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_218657_a("InputInventory", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inventory, null)));
        this.outputTank.ifPresent(h -> {
            CompoundNBT tankTag = h.writeToNBT(new CompoundNBT());
            compoundNBT.func_218657_a("OutputTank", (INBT)tankTag);
        });
        this.energyStorage.ifPresent(h -> {
            CompoundNBT energyTag = (CompoundNBT)h.serializeNBT();
            compoundNBT.func_218657_a("Energy", (INBT)energyTag);
        });
        CompoundNBT dyeTag = new CompoundNBT();
        dyeTag.func_74768_a("Red", this.red);
        dyeTag.func_74768_a("Yellow", this.yellow);
        dyeTag.func_74768_a("Blue", this.blue);
        dyeTag.func_74768_a("White", this.white);
        compoundNBT.func_218657_a("InternalTanks", (INBT)dyeTag);
        return super.func_189515_b(compoundNBT);
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> SqueezerTileEntity");
        debug.add("      r:" + this.red + " y:" + this.yellow + " b:" + this.blue + " w:" + this.white);
        this.outputTank.ifPresent(h -> debug.add("     p:" + h.getFluidAmount()));
        return debug;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.woot.squeezer.name", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new DyeSqueezerContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getRed() {
        return this.red;
    }

    public int getYellow() {
        return this.yellow;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getWhite() {
        return this.white;
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (((Boolean)this.outputTank.map(WootFluidTank::isEmpty).orElse((Object)true)).booleanValue()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            LazyOptional lazyOptional;
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
            if (!(te instanceof TileEntity) || !(lazyOptional = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())).isPresent()) continue;
            IFluidHandler iFluidHandler = (IFluidHandler)lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = (FluidStack)this.outputTank.map(WootFluidTank::getFluid).orElse((Object)FluidStack.EMPTY);
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.outputTank.ifPresent(f -> f.internalDrain(filled, IFluidHandler.FluidAction.EXECUTE));
            this.func_70296_d();
        }
    }

    @Override
    protected boolean hasEnergy() {
        return (Boolean)this.energyStorage.map(e -> e.getEnergyStored() > 0).orElse((Object)false);
    }

    @Override
    protected int useEnergy() {
        return (Integer)this.energyStorage.map(e -> e.extractEnergy((Integer)SqueezerConfiguration.DYE_SQUEEZER_ENERGY_PER_TICK.get(), false)).orElse((Object)0);
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.getEnergy() : 0;
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    @Override
    protected void processFinish() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        DyeSqueezerRecipe finishedRecipe = this.currRecipe;
        this.red += finishedRecipe.getRed();
        this.yellow += finishedRecipe.getYellow();
        this.blue += finishedRecipe.getBlue();
        this.white += finishedRecipe.getWhite();
        this.inventory.extractItem(INPUT_SLOT, 1, false);
        this.outputTank.ifPresent(f -> {
            while (this.canCreateOutput() && this.canStoreOutput()) {
                f.internalFill(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 288), IFluidHandler.FluidAction.EXECUTE);
                this.red -= 72;
                this.yellow -= 72;
                this.blue -= 72;
                this.white -= 72;
            }
        });
        this.func_70296_d();
    }

    @Override
    protected boolean canStart() {
        if (((Boolean)this.energyStorage.map(f -> f.getEnergyStored() <= 0).orElse((Object)true)).booleanValue()) {
            return false;
        }
        if (this.inventory.getStackInSlot(INPUT_SLOT).func_190926_b()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        return this.canStoreInternal(this.currRecipe);
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        return !this.inventory.getStackInSlot(INPUT_SLOT).func_190926_b();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        this.currRecipe = this.field_145850_b.func_199532_z().func_215371_a(DyeSqueezerRecipe.DYE_SQUEEZER_TYPE, (IInventory)new Inventory(new ItemStack[]{this.inventory.getStackInSlot(INPUT_SLOT)}), this.field_145850_b).orElse(null);
    }

    private boolean canStoreInternal(DyeSqueezerRecipe recipe) {
        if (recipe.getRed() + this.red > (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()) {
            return false;
        }
        if (recipe.getYellow() + this.yellow > (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()) {
            return false;
        }
        if (recipe.getBlue() + this.blue > (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get()) {
            return false;
        }
        return recipe.getWhite() + this.white <= (Integer)SqueezerConfiguration.DYE_SQUEEZER_INTERNAL_FLUID_MAX.get();
    }

    private boolean canCreateOutput() {
        return this.red >= 72 && this.yellow >= 72 && this.blue >= 72 && this.white >= 72;
    }

    private boolean canStoreOutput() {
        return (Boolean)this.outputTank.map(h -> h.internalFill(new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 288), IFluidHandler.FluidAction.SIMULATE) == 288).orElse((Object)false);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryGetter.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.outputTank.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropContents(World world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventory.getStackInSlot(INPUT_SLOT).func_77946_l();
        if (!itemStack.func_190926_b()) {
            drops.add(itemStack);
            this.inventory.insertItem(INPUT_SLOT, ItemStack.field_190927_a, false);
        }
        super.dropContents(drops);
    }

    public TankPacket getOutputTankPacket() {
        return new TankPacket(0, (FluidStack)this.outputTank.map(f -> f.getFluid()).orElse((Object)FluidStack.EMPTY));
    }
}

