/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import ipsis.woot.modules.oracle.blocks.OracleContainer;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class OracleScreen
extends ContainerScreen<OracleContainer> {
    private ResourceLocation GUI = new ResourceLocation("woot", "textures/gui/oracle.png");
    private Button nextMobButton;
    private Button prevMobButton;
    private int mobIndex = 0;

    public OracleScreen(OracleContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.field_146999_f = 180;
        this.field_147000_g = 177;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.width - this.field_146999_f) / 2;
        int relY = (this.height - this.field_147000_g) / 2;
        this.blit(relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!((OracleContainer)this.field_147002_h).simulatedDrops.isEmpty()) {
            int currRow = 0;
            int currCol = 0;
            for (SimulatedMobDropSummary summary : ((OracleContainer)this.field_147002_h).simulatedDrops) {
                int stackX = this.field_147003_i + currCol * 18 + 10;
                int stackY = this.field_147009_r + currRow * 18 + 41;
                RenderHelper.func_227780_a_();
                this.itemRenderer.func_175042_a(summary.itemStack, stackX, stackY);
                if (++currCol != 9) continue;
                currCol = 0;
                ++currRow;
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String text = this.title.func_150254_d();
        this.font.func_211126_b(text, (float)(this.field_146999_f / 2 - this.font.func_78256_a(text) / 2), 6.0f, 0x404040);
        if (((OracleContainer)this.field_147002_h).simulatedMobs.isEmpty()) {
            String mob = "N/A";
            this.font.func_211126_b(mob, (float)(this.field_146999_f / 2 - this.font.func_78256_a(mob) / 2), 25.0f, 0x404040);
        } else {
            FakeMob fakeMob = ((OracleContainer)this.field_147002_h).simulatedMobs.get(this.mobIndex);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
            if (entityType != null) {
                String mob = new TranslationTextComponent(entityType.func_210760_d(), new Object[0]).func_150254_d();
                if (fakeMob.hasTag()) {
                    mob = mob + "[" + fakeMob.getTag() + "]";
                }
                this.font.func_211126_b(mob, (float)(this.field_146999_f / 2 - this.font.func_78256_a(mob) / 2), 25.0f, 0x404040);
            }
        }
        if (!((OracleContainer)this.field_147002_h).simulatedDrops.isEmpty()) {
            int currRow = 0;
            int currCol = 0;
            for (SimulatedMobDropSummary summary : ((OracleContainer)this.field_147002_h).simulatedDrops) {
                int stackX = currCol * 18 + 10;
                int stackY = currRow * 18 + 41;
                if (mouseX - this.field_147003_i > stackX && mouseX - this.field_147003_i <= stackX + 20 && mouseY - this.field_147009_r >= stackY && mouseY - this.field_147009_r <= stackY + 20) {
                    FontRenderer fontRenderer = summary.itemStack.func_77973_b().getFontRenderer(summary.itemStack);
                    if (fontRenderer == null) {
                        fontRenderer = this.font;
                    }
                    List tooltip = this.getTooltipFromItem(summary.itemStack);
                    tooltip.add(String.format("No looting : %.2f%%", Float.valueOf(summary.chanceToDrop[0])));
                    tooltip.add(String.format("Looting 1 : %.2f%%", Float.valueOf(summary.chanceToDrop[1])));
                    tooltip.add(String.format("Looting 2 : %.2f%%", Float.valueOf(summary.chanceToDrop[2])));
                    tooltip.add(String.format("Looting 3: %.2f%%", Float.valueOf(summary.chanceToDrop[3])));
                    this.renderTooltip(tooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r, fontRenderer);
                    break;
                }
                if (++currCol != 9) continue;
                currCol = 0;
                ++currRow;
            }
        }
    }

    protected void init() {
        super.init();
        this.nextMobButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 9 + 144, this.field_147009_r + 18, 18, 18, ">", h -> {
            if (!((OracleContainer)this.field_147002_h).simulatedMobs.isEmpty()) {
                ++this.mobIndex;
                this.mobIndex = MathHelper.func_76125_a((int)this.mobIndex, (int)0, (int)(((OracleContainer)this.field_147002_h).simulatedMobs.size() - 1));
                ((OracleContainer)this.field_147002_h).refreshDrops(this.mobIndex);
            }
        }));
        this.prevMobButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 9, this.field_147009_r + 18, 18, 18, "<", h -> {
            if (!((OracleContainer)this.field_147002_h).simulatedMobs.isEmpty()) {
                --this.mobIndex;
                this.mobIndex = MathHelper.func_76125_a((int)this.mobIndex, (int)0, (int)(((OracleContainer)this.field_147002_h).simulatedMobs.size() - 1));
                ((OracleContainer)this.field_147002_h).refreshDrops(this.mobIndex);
            }
        }));
        ((OracleContainer)this.field_147002_h).refreshMobs();
    }
}

