/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.layout.blocks.LayoutTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class LayoutTileEntitySpecialRenderer
extends TileEntityRenderer<LayoutTileEntity> {
    public LayoutTileEntitySpecialRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean isGlobalRenderer(LayoutTileEntity te) {
        return true;
    }

    public void render(LayoutTileEntity layoutTileEntity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (layoutTileEntity.getAbsolutePattern() == null) {
            layoutTileEntity.refresh();
        }
        this.textureRender(layoutTileEntity, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    void textureRender(LayoutTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean showAll = tileEntityIn.getLevel() == -1;
        int validY = showAll ? 0 : tileEntityIn.getYForLevel();
        BlockPos origin = tileEntityIn.func_174877_v();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        for (PatternBlock block : tileEntityIn.getAbsolutePattern().getBlocks()) {
            if (!showAll && block.getBlockPos().func_177956_o() != validY) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(origin.func_177958_n() - block.getBlockPos().func_177958_n()) * -1.0f), (double)((float)(origin.func_177956_o() - block.getBlockPos().func_177956_o()) * -1.0f), (double)((float)(origin.func_177952_p() - block.getBlockPos().func_177952_p()) * -1.0f));
            BlockState blockState = block.getFactoryComponent().getDefaultBlockState();
            if (block.getFactoryComponent() == FactoryComponent.HEART) {
                blockState = (BlockState)((HeartBlock)FactorySetup.HEART_BLOCK.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((IProperty)BlockStateProperties.field_208157_J));
            }
            Minecraft.func_71410_x().func_175602_ab().renderBlock(blockState, matrixStack, bufferIn, 0xF000F0, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

