/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.infuser.blocks;

import ipsis.woot.crafting.InfuserRecipe;
import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.modules.infuser.blocks.InfuserContainer;
import ipsis.woot.util.EnchantingHelper;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootEnergyStorage;
import ipsis.woot.util.WootMachineTileEntity;
import ipsis.woot.util.oss.OutputOnlyItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class InfuserTileEntity
extends WootMachineTileEntity
implements WootDebug,
INamedContainerProvider {
    private boolean firstTick = true;
    private LazyOptional<FluidTank> inputTank = LazyOptional.of(this::createTank);
    private LazyOptional<WootEnergyStorage> energyStorage = LazyOptional.of(this::createEnergy);
    public static final int INPUT_SLOT = 0;
    public static final int AUGMENT_SLOT = 1;
    public static final int OUTPUT_SLOT = 0;
    private ItemStackHandler inputSlots;
    private ItemStackHandler outputSlot;
    private ItemStackHandler outputWrappedSlot;
    private final LazyOptional<IItemHandler> inputSlotHandler = LazyOptional.of(() -> this.inputSlots);
    private final LazyOptional<IItemHandler> outputWrappedSlotHandler = LazyOptional.of(() -> this.outputWrappedSlot);
    private final LazyOptional<IItemHandler> allSlotHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlots, this.outputSlot}));
    private InfuserRecipe currRecipe = null;

    public InfuserTileEntity() {
        super((TileEntityType)InfuserSetup.INFUSER_BLOCK_TILE.get());
        this.inputSlots = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                InfuserTileEntity.this.onContentsChanged(slot);
                InfuserTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return InfuserRecipe.isValidInput(stack);
                }
                if (slot == 1) {
                    return InfuserRecipe.isValidAugment(stack);
                }
                return false;
            }
        };
        this.outputSlot = new ItemStackHandler();
        this.outputWrappedSlot = new OutputOnlyItemStackHandler(this.outputSlot);
    }

    public void configureSides() {
        Direction direction = (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        if (direction == Direction.NORTH) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.INPUT);
        } else if (direction == Direction.SOUTH) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.OUTPUT);
        } else if (direction == Direction.WEST) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.INPUT);
        } else if (direction == Direction.EAST) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.firstTick && this.field_145850_b != null) {
            this.configureSides();
            this.firstTick = false;
        }
        super.func_73660_a();
    }

    private FluidTank createTank() {
        return new FluidTank(((Integer)InfuserConfiguration.INFUSER_TANK_CAPACITY.get()).intValue(), h -> InfuserRecipe.isValidFluid(h));
    }

    public void setTankFluid(FluidStack fluidStack) {
        this.inputTank.ifPresent(h -> h.setFluid(fluidStack));
    }

    public FluidStack getTankFluid() {
        return (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
    }

    private WootEnergyStorage createEnergy() {
        return new WootEnergyStorage((Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY_RX.get());
    }

    public int getEnergy() {
        return (Integer)this.energyStorage.map(h -> h.getEnergyStored()).orElse((Object)0);
    }

    public void setEnergy(int v) {
        this.energyStorage.ifPresent(h -> h.setEnergy(v));
    }

    public void func_145839_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_150297_b("InputInventory", 9)) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inputSlots, null, (INBT)compoundNBT.func_150295_c("InputInventory", 10));
        }
        if (compoundNBT.func_150297_b("OutputInventory", 9)) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.outputSlot, null, (INBT)compoundNBT.func_150295_c("OutputInventory", 10));
        }
        CompoundNBT tankTag = compoundNBT.func_74775_l("InputTank");
        this.inputTank.ifPresent(h -> h.readFromNBT(tankTag));
        CompoundNBT energyTag = compoundNBT.func_74775_l("Energy");
        this.energyStorage.ifPresent(h -> h.deserializeNBT((INBT)energyTag));
        super.func_145839_a(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_218657_a("InputInventory", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inputSlots, null)));
        compoundNBT.func_218657_a("OutputInventory", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.outputSlot, null)));
        this.inputTank.ifPresent(h -> {
            CompoundNBT tankTag = h.writeToNBT(new CompoundNBT());
            compoundNBT.func_218657_a("InputTank", (INBT)tankTag);
        });
        this.energyStorage.ifPresent(h -> {
            CompoundNBT energyTag = (CompoundNBT)h.serializeNBT();
            compoundNBT.func_218657_a("Energy", (INBT)energyTag);
        });
        return super.func_189515_b(compoundNBT);
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> InfuserTileEntity");
        debug.add("      Tank " + this.getTankFluid().getTranslationKey() + " " + this.getTankFluid().getAmount());
        debug.add("      Energy " + this.getEnergy());
        return debug;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.woot.infuser.name", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new InfuserContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return (Boolean)this.energyStorage.map(e -> e.getEnergyStored() > 0).orElse((Object)false);
    }

    @Override
    protected int useEnergy() {
        return (Integer)this.energyStorage.map(e -> e.extractEnergy((Integer)InfuserConfiguration.INFUSER_ENERGY_PER_TICK.get(), false)).orElse((Object)0);
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.getEnergy() : 0;
    }

    @Override
    protected void processFinish() {
        ItemStack itemStack;
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        InfuserRecipe finishedRecipe = this.currRecipe;
        int inputSize = finishedRecipe.getIngredient().func_193365_a()[0].func_190916_E();
        int augmentSize = finishedRecipe.hasAugment() ? finishedRecipe.getAugment().func_193365_a()[0].func_190916_E() : 1;
        this.inputSlots.extractItem(0, inputSize, false);
        if (finishedRecipe.hasAugment()) {
            this.inputSlots.extractItem(1, augmentSize, false);
        }
        if ((itemStack = finishedRecipe.getOutput()).func_77973_b() == Items.field_151134_bR) {
            int level = itemStack.func_190916_E();
            itemStack = new ItemStack((IItemProvider)Items.field_151122_aG, 1);
            itemStack = EnchantingHelper.addRandomBookEnchant(itemStack, level);
        }
        this.outputSlot.insertItem(0, itemStack, false);
        this.inputTank.ifPresent(f -> f.drain(finishedRecipe.getFluidInput().getAmount(), IFluidHandler.FluidAction.EXECUTE));
        this.func_70296_d();
    }

    @Override
    protected boolean canStart() {
        if (((Boolean)this.energyStorage.map(f -> f.getEnergyStored() <= 0).orElse((Object)true)).booleanValue()) {
            return false;
        }
        if (this.inputSlots.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (((Boolean)this.inputTank.map(f -> f.isEmpty()).orElse((Object)true)).booleanValue()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        if (this.currRecipe.hasAugment() && this.currRecipe.getAugmentCount() > this.inputSlots.getStackInSlot(1).func_190916_E()) {
            return false;
        }
        if (this.outputSlot.getStackInSlot(0).func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.currRecipe.getOutput(), (ItemStack)this.outputSlot.getStackInSlot(0));
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        if (this.inputSlots.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        return !this.currRecipe.hasAugment() || this.currRecipe.getAugmentCount() <= this.inputSlots.getStackInSlot(1).func_190916_E();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        if (((Boolean)this.inputTank.map(h -> h.isEmpty()).orElse((Object)false)).booleanValue()) {
            this.clearRecipe();
            return;
        }
        List recipes = this.field_145850_b.func_199532_z().func_215370_b(InfuserRecipe.INFUSER_TYPE, (IInventory)new Inventory(new ItemStack[]{this.inputSlots.getStackInSlot(0), this.inputSlots.getStackInSlot(1)}), this.field_145850_b);
        if (!recipes.isEmpty()) {
            FluidStack fluidStack = (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
            for (InfuserRecipe r : recipes) {
                if (!r.getFluidInput().isFluidEqual(fluidStack)) continue;
                this.currRecipe = r;
                return;
            }
        }
        this.clearRecipe();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.allSlotHandler.cast();
            }
            if (this.settings.get(side) == WootMachineTileEntity.Mode.INPUT) {
                return this.inputSlotHandler.cast();
            }
            if (this.settings.get(side) == WootMachineTileEntity.Mode.OUTPUT) {
                return this.outputWrappedSlotHandler.cast();
            }
            return this.allSlotHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.inputTank.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropContents(World world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inputSlots.getStackInSlot(0);
        if (!itemStack.func_190926_b()) {
            drops.add(itemStack);
            this.inputSlots.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (!(itemStack = this.inputSlots.getStackInSlot(1)).func_190926_b()) {
            drops.add(itemStack);
            this.inputSlots.setStackInSlot(1, ItemStack.field_190927_a);
        }
        if (!(itemStack = this.outputSlot.getStackInSlot(0)).func_190926_b()) {
            drops.add(itemStack);
            this.outputSlot.setStackInSlot(0, ItemStack.field_190927_a);
        }
        super.dropContents(drops);
    }
}

