/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.Perk;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactoryScanner {
    private static final Logger LOGGER = LogManager.getLogger();

    @Nullable
    public static AbsolutePattern scanTier(World world, Tier tier, BlockPos origin, Direction facing) {
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, origin, facing);
        return FactoryScanner.compareToWorldQuick(absolutePattern, world);
    }

    @Nullable
    public static AbsolutePattern scanForTier(World world, BlockPos origin, Direction facing) {
        Tier tier;
        for (int i = Tier.VALUES.length - 1; i >= 0 && (tier = Tier.byIndex(i)) != Tier.UNKNOWN; --i) {
            AbsolutePattern absolutePattern = FactoryScanner.scanTier(world, tier, origin, facing);
            if (absolutePattern == null) continue;
            return absolutePattern;
        }
        return null;
    }

    @Nullable
    public static AbsolutePattern compareToWorldQuick(AbsolutePattern absolutePattern, World world) {
        ArrayList<String> feedback = new ArrayList<String>();
        boolean valid = FactoryScanner.compareToWorld(absolutePattern, world, feedback);
        return valid ? absolutePattern : null;
    }

    public static boolean compareToWorld(AbsolutePattern absolutePattern, World world, List<String> feedback) {
        boolean valid = true;
        boolean foundPrimaryController = false;
        Woot.setup.getLogger().debug("compareToWorld: {}", (Object)absolutePattern.getTier());
        BlockPos heartPos = null;
        for (PatternBlock p : absolutePattern.getBlocks()) {
            if (p.getFactoryComponent() != FactoryComponent.HEART) continue;
            heartPos = new BlockPos((Vec3i)p.getBlockPos());
        }
        if (heartPos == null) {
            return false;
        }
        BlockPos primaryControllerPos = new BlockPos((Vec3i)heartPos.func_177967_a(absolutePattern.facing, 1).func_177982_a(0, -2, 0));
        for (PatternBlock p : absolutePattern.getBlocks()) {
            FakeMob fakeMob;
            TileEntity te;
            if (!world.func_175667_e(p.getBlockPos())) {
                valid = false;
                continue;
            }
            BlockState currState = world.func_180495_p(p.getBlockPos());
            Block currBlock = currState.func_177230_c();
            String found = StringHelper.translate(currBlock.func_149739_a());
            String expected = StringHelper.translate(p.getFactoryComponent().getTranslationKey());
            if (p.getFactoryComponent() == FactoryComponent.CELL) {
                expected = StringHelper.translate("info.woot.intern.cell");
            }
            if (!(currBlock instanceof FactoryComponentProvider)) {
                if (p.getFactoryComponent() == FactoryComponent.CONTROLLER) continue;
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.missing", expected, p.getBlockPos().func_177958_n(), p.getBlockPos().func_177952_p(), p.getBlockPos().func_177952_p()));
                valid = false;
                continue;
            }
            FactoryComponentProvider factoryComponent = (FactoryComponentProvider)currBlock;
            if (!FactoryComponent.isSameComponentFuzzy(factoryComponent.getFactoryComponent(), p.getFactoryComponent())) {
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.incorrect", expected, p.getBlockPos().func_177958_n(), p.getBlockPos().func_177956_o(), p.getBlockPos().func_177952_p(), found));
                valid = false;
                continue;
            }
            if (p.getFactoryComponent() == FactoryComponent.FACTORY_UPGRADE) {
                BlockState blockState = world.func_180495_p(p.getBlockPos());
                absolutePattern.addPerk((Perk)((Object)blockState.func_177229_b(UpgradeBlock.UPGRADE)));
            }
            if (p.getFactoryComponent() != FactoryComponent.CONTROLLER || !((te = world.func_175625_s(p.getBlockPos())) instanceof ControllerTileEntity) || !(fakeMob = ((ControllerTileEntity)te).getFakeMob()).isValid()) continue;
            Tier mobTier = Config.OVERRIDE.getMobTier(fakeMob, world);
            if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation())) {
                Woot.setup.getLogger().debug("compareToWorld:    {} is invalid policy", (Object)fakeMob);
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.blacklisted", p.getBlockPos().func_177958_n(), p.getBlockPos().func_177956_o(), p.getBlockPos().func_177952_p()));
                continue;
            }
            if (!absolutePattern.getTier().isValidForTier(mobTier)) {
                Woot.setup.getLogger().debug("compareToWorld: {} is invalid tier", (Object)fakeMob);
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.wrongtier", new Object[]{p.getBlockPos().func_177958_n(), p.getBlockPos().func_177956_o(), p.getBlockPos().func_177952_p(), absolutePattern.getTier()}));
                continue;
            }
            absolutePattern.addControllerPos(p.getBlockPos());
            if (primaryControllerPos.equals((Object)p.getBlockPos())) {
                Woot.setup.getLogger().debug("compareToWorld: Found primary controller {}", (Object)fakeMob);
                foundPrimaryController = true;
                absolutePattern.addMob(fakeMob);
                continue;
            }
            Woot.setup.getLogger().debug("compareToWorld: Found valid secondary controller {}", (Object)fakeMob);
            absolutePattern.addMob(fakeMob);
        }
        if (!foundPrimaryController) {
            feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.noprimary", primaryControllerPos.func_177958_n(), primaryControllerPos.func_177956_o(), primaryControllerPos.func_177952_p()));
            valid = false;
        }
        if (!valid) {
            absolutePattern.clearMobs();
            absolutePattern.clearControllerPos();
        }
        LOGGER.debug("compareToWorld: {}", (Object)absolutePattern);
        return valid;
    }

    public static boolean isPatternEqual(@Nonnull World world, AbsolutePattern pattern1, AbsolutePattern pattern2) {
        if (pattern1 == null || pattern2 == null) {
            return false;
        }
        if (pattern1.tier != pattern2.tier) {
            return false;
        }
        if (pattern1.mobs.size() != pattern2.mobs.size()) {
            return false;
        }
        for (FakeMob fakeMob : pattern1.mobs) {
            if (pattern2.mobs.contains(fakeMob)) continue;
            return false;
        }
        if (pattern1.perks.size() != pattern2.perks.size()) {
            return false;
        }
        for (Perk perk : pattern1.perks) {
            if (pattern2.perks.contains((Object)perk)) continue;
            return false;
        }
        return true;
    }
}

