/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.generators;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.PerkType;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.generators.ShardPerkData;
import ipsis.woot.modules.factory.items.XpShardBaseItem;
import ipsis.woot.modules.generic.items.GenericItem;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import ipsis.woot.util.helper.RandomHelper;
import ipsis.woot.util.helper.StorageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootGeneration {
    static final Logger LOGGER = LogManager.getLogger();
    static final Random RANDOM = new Random();
    static LootGeneration INSTANCE = new LootGeneration();

    public static LootGeneration get() {
        return INSTANCE;
    }

    public void generate(HeartTileEntity heartTileEntity, FormedSetup setup) {
        List<LazyOptional<IItemHandler>> itemHandlers = setup.getExportHandlers();
        int looting = setup.getLootingLevel();
        ArrayList<ItemStack> rolledDrops = new ArrayList<ItemStack>();
        for (FakeMob fakeMob : setup.getAllMobs()) {
            int mobCount = setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)PerkType.MASS));
            LOGGER.debug("generate: {} * {}", (Object)fakeMob, (Object)mobCount);
            FakeMobKey fakeMobKey = new FakeMobKey(fakeMob, looting);
            for (int i = 0; i < mobCount; ++i) {
                rolledDrops.addAll(MobSimulator.getInstance().getRolledDrops(fakeMobKey));
            }
        }
        StorageHelper.insertItems(rolledDrops, itemHandlers);
        if (setup.getAllPerks().containsKey((Object)PerkType.XP)) {
            int genXp = 0;
            for (FakeMob mob : setup.getAllMobs()) {
                int xpPercent = setup.getAllMobParams().get(mob).getPerkXpValue();
                int mobCount = setup.getAllMobParams().get(mob).getMobCount(setup.getAllPerks().containsKey((Object)PerkType.MASS));
                int x = (int)((float)SpawnController.get().getMobExperience(mob, setup.getWorld()) / 100.0f * (float)xpPercent);
                genXp += x * mobCount;
            }
            List<ItemStack> list = XpShardBaseItem.getShards(genXp);
            StorageHelper.insertItems(list, itemHandlers);
        }
        if (setup.getAllPerks().containsKey((Object)PerkType.TIER_SHARD)) {
            ArrayList<ShardPerkData> shards = new ArrayList<ShardPerkData>();
            shards.add(new ShardPerkData(GenericItem.GenericItemType.BASIC_UP_SHARD, setup.getBasicShardWeight()));
            shards.add(new ShardPerkData(GenericItem.GenericItemType.ADVANCED_UP_SHARD, setup.getAdvancedShardWeight()));
            shards.add(new ShardPerkData(GenericItem.GenericItemType.ELITE_UP_SHARD, setup.getEliteShardWeight()));
            int n = setup.getPerkTierShardValue();
            ArrayList<ItemStack> dropShards = new ArrayList<ItemStack>();
            Woot.setup.getLogger().debug("Shard gen installed");
            Woot.setup.getLogger().debug("Level:{} Drop:{} Basic:{} Advanced:{} Elite:{} Rolls:{}", (Object)setup.getAllPerks().get((Object)PerkType.TIER_SHARD), (Object)setup.getShardDropChance(), (Object)setup.getBasicShardWeight(), (Object)setup.getAdvancedShardWeight(), (Object)setup.getEliteShardWeight(), (Object)n);
            for (int i = 0; i < n; ++i) {
                if (!RandomHelper.rollPercentage(setup.getShardDropChance())) continue;
                ShardPerkData chosenShard = (ShardPerkData)WeightedRandom.func_76271_a((Random)RANDOM, shards);
                dropShards.add(chosenShard.getItemStack());
            }
            StorageHelper.insertItems(dropShards, itemHandlers);
        }
    }
}

