/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.multiblock.MultiBlockTileEntity;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class CellTileEntityBase
extends MultiBlockTileEntity
implements WootDebug {
    protected FluidTank tank = new FluidTank(1000);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public CellTileEntityBase(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.tank.setCapacity(this.getCapacity());
        this.tank.setValidator(e -> e.getFluid() == ((FlowingFluid)FluidSetup.CONATUS_FLUID.get()).getFluid());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Tank")) {
            this.tank.readFromNBT(compound.func_74775_l("Tank"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        CompoundNBT tankNBT = new CompoundNBT();
        this.tank.writeToNBT(tankNBT);
        compound.func_218657_a("Tank", (INBT)tankNBT);
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void fillToCapacity() {
        this.tank.fill(new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), this.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
    }

    public abstract int getCapacity();

    public abstract int getMaxTransfer();

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> CellTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      capacity: " + this.tank.getCapacity());
        debug.add("      transfer: " + this.getMaxTransfer());
        debug.add("      contains: " + this.tank.getFluid().getTranslationKey());
        debug.add("      contains: " + this.tank.getFluid().getAmount());
        return debug;
    }
}

