/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.blocks;

import ipsis.woot.crafting.AnvilRecipe;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.anvil.blocks.AnvilBlock;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.items.MobShardItem;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.helper.PlayerHelper;
import ipsis.woot.util.helper.WorldHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AnvilTileEntity
extends TileEntity
implements WootDebug {
    private ItemStack baseItem = ItemStack.field_190927_a;
    private ItemStack[] ingredients = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};

    public AnvilTileEntity() {
        super((TileEntityType)AnvilSetup.ANVIL_BLOCK_TILE.get());
    }

    public boolean hasBaseItem() {
        return !this.baseItem.func_190926_b();
    }

    public void setBaseItem(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        this.baseItem = itemStack.func_77946_l();
        this.func_70296_d();
        if (this.field_145850_b != null) {
            WorldHelper.updateClient(this.field_145850_b, this.field_174879_c);
        }
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public ItemStack getBaseItem() {
        return this.baseItem.func_77946_l();
    }

    public boolean addIngredient(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (!this.ingredients[i].func_190926_b()) continue;
            this.ingredients[i] = itemStack.func_77946_l();
            this.func_70296_d();
            if (this.field_145850_b != null) {
                WorldHelper.updateClient(this.field_145850_b, this.field_174879_c);
            }
            return true;
        }
        return false;
    }

    public void dropContents(World world, BlockPos pos) {
        if (!this.baseItem.func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.baseItem);
            this.baseItem = ItemStack.field_190927_a;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i].func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.ingredients[i]);
            this.ingredients[i] = ItemStack.field_190927_a;
        }
        this.func_70296_d();
        if (world != null) {
            WorldHelper.updateClient(world, pos);
        }
    }

    public void dropItem(PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStack.field_190927_a;
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i].func_190926_b()) continue;
            itemStack = this.ingredients[i].func_77946_l();
            this.ingredients[i] = ItemStack.field_190927_a;
            break;
        }
        if (itemStack.func_190926_b() && !this.baseItem.func_190926_b()) {
            itemStack = this.baseItem;
            this.baseItem = ItemStack.field_190927_a;
        }
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
            if (this.field_145850_b != null) {
                WorldHelper.updateClient(this.field_145850_b, this.field_174879_c);
            }
            if (!playerEntity.field_71071_by.func_70441_a(itemStack)) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)itemStack);
            } else {
                playerEntity.field_71070_bA.func_75142_b();
            }
        }
    }

    public void tryCraft(PlayerEntity playerEntity) {
        if (!((AnvilBlock)AnvilSetup.ANVIL_BLOCK.get()).isAnvilHot(this.field_145850_b, this.field_174879_c)) {
            PlayerHelper.sendActionBarMessage(playerEntity, new TranslationTextComponent("chat.woot.anvil.cold", new Object[0]).func_150254_d());
            return;
        }
        AnvilRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(AnvilRecipe.ANVIL_TYPE, (IInventory)new Inventory(new ItemStack[]{this.baseItem, this.ingredients[0], this.ingredients[1], this.ingredients[2], this.ingredients[3]}), this.field_145850_b).orElse(null);
        if (recipe == null) {
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.baseItem.func_77973_b() == FactorySetup.MOB_SHARD_ITEM.get()) {
            FakeMob fakeMob = MobShardItem.getProgrammedMob(this.baseItem);
            output = ControllerTileEntity.getItemStack(fakeMob);
        }
        this.baseItem = ItemStack.field_190927_a;
        for (int i = 0; i < this.ingredients.length; ++i) {
            this.ingredients[i] = ItemStack.field_190927_a;
        }
        this.func_70296_d();
        WorldHelper.updateClient(this.field_145850_b, this.field_174879_c);
        ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), output);
        itemEntity.func_174869_p();
        this.field_145850_b.func_217376_c((Entity)itemEntity);
    }

    public void func_145839_a(CompoundNBT compoundNBT) {
        super.func_145839_a(compoundNBT);
        if (compoundNBT.func_74764_b("BaseItem")) {
            ListNBT listNBT = compoundNBT.func_150295_c("Inventory", 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT itemTags = listNBT.func_150305_b(i);
                int j = itemTags.func_74762_e("Slot");
                if (j < 0 || j >= this.ingredients.length) continue;
                this.ingredients[j] = ItemStack.func_199557_a((CompoundNBT)itemTags);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        if (!this.baseItem.func_190926_b()) {
            CompoundNBT compoundNBT1 = new CompoundNBT();
            this.baseItem.func_77955_b(compoundNBT1);
            compoundNBT.func_218657_a("BaseItem", (INBT)compoundNBT1);
            ListNBT listNBT = new ListNBT();
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (this.ingredients[i].func_190926_b()) continue;
                CompoundNBT itemTags = new CompoundNBT();
                itemTags.func_74768_a("Slot", i);
                this.ingredients[i].func_77955_b(itemTags);
                listNBT.add((Object)itemTags);
            }
            compoundNBT.func_218657_a("Inventory", (INBT)listNBT);
        }
        return compoundNBT;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.func_189515_b(compoundNBT);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, compoundNBT);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> AnvilTileEntity");
        debug.add("      base: " + this.baseItem);
        for (int i = 0; i < this.ingredients.length; ++i) {
            debug.add("      ingredient: " + this.ingredients[i]);
        }
        return debug;
    }
}

