/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.util.FluidStackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class InfuserRecipe
implements IRecipe<IInventory> {
    private final Ingredient ingredient;
    private final Ingredient augment;
    private final int augmentCount;
    private final FluidStack fluid;
    private final Item result;
    private final int count;
    private final int energy;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    public static final IRecipeType<InfuserRecipe> INFUSER_TYPE = IRecipeType.func_222147_a((String)"infuser");
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();
    private static List<ItemStack> validAugments = new ArrayList<ItemStack>();
    private static List<FluidStack> validFluids = new ArrayList<FluidStack>();
    @ObjectHolder(value="woot:infuser")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public InfuserRecipe(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, IItemProvider result, int count, int energy) {
        this.id = id;
        this.ingredient = ingredient;
        this.augment = augment;
        this.augmentCount = augmentCount;
        this.fluid = fluidStack;
        this.result = result.func_199767_j();
        this.count = count;
        this.type = INFUSER_TYPE;
        this.energy = energy;
        this.inputs.add(Arrays.asList(ingredient.func_193365_a()));
        if (this.hasAugment()) {
            List<ItemStack> stacks = Arrays.asList(augment.func_193365_a());
            for (ItemStack stack : stacks) {
                stack.func_190920_e(augmentCount);
            }
            this.inputs.add(stacks);
        }
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean hasAugment() {
        return this.augment != Ingredient.field_193370_a;
    }

    public Ingredient getAugment() {
        return this.augment;
    }

    public int getAugmentCount() {
        return this.augmentCount;
    }

    public ItemStack getOutput() {
        return new ItemStack((IItemProvider)this.result, this.count);
    }

    public FluidStack getFluidInput() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public static InfuserRecipe infuserRecipe(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, IItemProvider result, int count, int energy) {
        return new InfuserRecipe(id, ingredient, augment, augmentCount, fluidStack, result, count, energy);
    }

    public static InfuserRecipe infuserRecipe(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, IItemProvider result, int energy) {
        return new InfuserRecipe(id, ingredient, augment, augmentCount, fluidStack, result, 1, energy);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == null || this.fluid.isEmpty()) {
            throw new IllegalStateException("No valid ingredient or fluid for recipe " + id);
        }
        consumer.accept(new Finished(id, this.ingredient, this.augment, this.augmentCount, this.fluid, this.result, this.count, this.energy));
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidAugments() {
        validAugments.clear();
    }

    public static void addValidAugment(ItemStack itemStack) {
        validAugments.add(itemStack);
    }

    public static boolean isValidAugment(ItemStack itemStack) {
        for (ItemStack i : validAugments) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidFluids() {
        validFluids.clear();
    }

    public static void addValidFluid(FluidStack fluidStack) {
        validFluids.add(fluidStack);
    }

    public static boolean isValidFluid(FluidStack fluidStack) {
        for (FluidStack f : validFluids) {
            if (!f.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack invStack;
        if (!this.ingredient.test(inv.func_70301_a(0))) {
            return false;
        }
        if (!(this.augment == Ingredient.field_193370_a || this.augment.test(invStack = inv.func_70301_a(1)) && this.augmentCount == invStack.func_190916_E())) {
            return false;
        }
        return this.augment == Ingredient.field_193370_a || this.augment.test(inv.func_70301_a(1));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public static class Finished
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient augment;
        private final int augmentCount;
        private final FluidStack fluid;
        private final Item result;
        private final int count;
        private final int energy;

        private Finished(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, Item result, int count, int energy) {
            this.id = id;
            this.ingredient = ingredient;
            this.augment = augment;
            this.augmentCount = augmentCount;
            this.fluid = fluidStack;
            this.result = result;
            this.count = count;
            this.energy = energy;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            if (this.augment != Ingredient.field_193370_a) {
                json.add("augment", this.augment.func_200304_c());
                if (this.augmentCount > 1) {
                    json.addProperty("augment_count", (Number)this.augmentCount);
                }
            }
            json.add("infuse", (JsonElement)FluidStackHelper.create(this.fluid));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

