/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.util.FluidStackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;

public class FluidConvertorRecipe
implements IRecipe<IInventory> {
    private final Ingredient catalyst;
    private final int catalystCount;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;
    private final int energy;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    public static final IRecipeType<FluidConvertorRecipe> FLUID_CONV_TYPE = IRecipeType.func_222147_a((String)"fluidconvertor");
    private static List<ItemStack> validCatalysts = new ArrayList<ItemStack>();
    private static List<FluidStack> validInputs = new ArrayList<FluidStack>();
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    @ObjectHolder(value="woot:fluidconvertor")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public FluidConvertorRecipe(ResourceLocation id, Ingredient catalyst, int catalystCount, FluidStack fluidStack, FluidStack outputFluid, int energy) {
        this.id = id;
        this.catalyst = catalyst;
        this.catalystCount = catalystCount;
        this.inputFluid = fluidStack;
        this.outputFluid = outputFluid;
        this.type = FLUID_CONV_TYPE;
        this.energy = energy;
        this.inputs.add(Arrays.asList(catalyst.func_193365_a()));
    }

    public static FluidConvertorRecipe convertorRecipe(ResourceLocation id, Ingredient catalyst, int catalystCount, FluidStack fluidStack, FluidStack outputFluid, int energy) {
        return new FluidConvertorRecipe(id, catalyst, catalystCount, fluidStack, outputFluid, energy);
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public int getCatalystCount() {
        return this.catalystCount;
    }

    public FluidStack getOutput() {
        return this.outputFluid.copy();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public String toString() {
        return "FluidConvertorRecipe{catalyst=" + this.catalyst + ", catalystCount=" + this.catalystCount + ", inputFluid=" + this.inputFluid + ", outputFluid=" + this.outputFluid + ", energy=" + this.energy + '}';
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.catalyst == null || this.inputFluid.isEmpty() || this.outputFluid.isEmpty()) {
            throw new IllegalStateException("No valid catalyst or fluid for recipe " + id);
        }
        consumer.accept(new Finished(id, this.catalyst, this.catalystCount, this.inputFluid, this.outputFluid, this.energy));
    }

    public static void clearValidCatalysts() {
        validCatalysts.clear();
    }

    public static void addValidCatalyst(ItemStack itemStack) {
        validCatalysts.add(itemStack);
    }

    public static boolean isValidCatalyst(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack i : validCatalysts) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(FluidStack fluidStack) {
        validInputs.add(fluidStack);
    }

    public static boolean isValidInput(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        for (FluidStack f : validInputs) {
            if (!f.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.catalyst.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public static class Finished
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient catalyst;
        private final int catalystcount;
        private final FluidStack inputFluid;
        private final FluidStack outputFluid;
        private final int energy;

        public Finished(ResourceLocation id, Ingredient catalyst, int catalystCount, FluidStack fluidStack, FluidStack outputFluid, int energy) {
            this.id = id;
            this.catalyst = catalyst;
            this.catalystcount = catalystCount;
            this.inputFluid = fluidStack;
            this.outputFluid = outputFluid;
            this.energy = energy;
        }

        public void func_218610_a(JsonObject json) {
            json.add("catalyst", this.catalyst.func_200304_c());
            json.addProperty("catalyst_count", (Number)this.catalystcount);
            json.add("input", (JsonElement)FluidStackHelper.create(this.inputFluid));
            json.add("result", (JsonElement)FluidStackHelper.create(this.outputFluid));
            json.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

