/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.jei;

import ipsis.woot.compat.jei.WootJeiPlugin;
import ipsis.woot.crafting.DyeSqueezerRecipe;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.util.helper.StringHelper;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DyeSqueezerRecipeCategory
implements IRecipeCategory<DyeSqueezerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("woot", "dyesqueezer");
    private static IDrawableStatic background;
    private final IDrawable icon;

    public DyeSqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("woot", "textures/gui/jei/squeezer.png");
        background = guiHelper.createDrawable(resourceLocation, 0, 0, 180, 86);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SqueezerSetup.SQUEEZER_BLOCK.get()));
    }

    public Class<? extends DyeSqueezerRecipe> getRecipeClass() {
        return DyeSqueezerRecipe.class;
    }

    public void setIngredients(DyeSqueezerRecipe recipe, IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        iIngredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, DyeSqueezerRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 38, 39);
        itemStacks.set(iIngredients);
        IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
        fluidStacks.init(0, false, 154, 40, 16, 16, 1000, true, null);
        fluidStacks.set(iIngredients);
    }

    public void draw(DyeSqueezerRecipe recipe, double mouseX, double mouseY) {
        IJeiRuntime runtime = WootJeiPlugin.jeiRuntime;
        if (runtime != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71466_p.func_211126_b("Red: " + recipe.getRed() + " mb", 70.0f, 28.0f, Color.BLACK.getRGB());
            minecraft.field_71466_p.func_211126_b("Yellow: " + recipe.getYellow() + " mb", 70.0f, 38.0f, Color.BLACK.getRGB());
            minecraft.field_71466_p.func_211126_b("Blue: " + recipe.getBlue() + " mb", 70.0f, 48.0f, Color.BLACK.getRGB());
            minecraft.field_71466_p.func_211126_b("White: " + recipe.getWhite() + " mb", 70.0f, 58.0f, Color.BLACK.getRGB());
            minecraft.field_71466_p.func_211126_b(String.format("%d RF", recipe.getEnergy()), 70.0f, 68.0f, Color.BLACK.getRGB());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public String getTitle() {
        return StringHelper.translate("gui.woot.squeezer.name");
    }

    public IDrawableStatic getBackground() {
        return background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

