/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;

public class CustomServerBossInfo
extends ServerBossInfo {
    private final ResourceLocation field_201373_h;
    private final Set<UUID> field_201374_i = Sets.newHashSet();
    private int field_201375_j;
    private int field_201376_k = 100;

    public CustomServerBossInfo(ResourceLocation resourceLocation, ITextComponent iTextComponent) {
        super(iTextComponent, BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
        this.field_201373_h = resourceLocation;
        this.func_186735_a(0.0f);
    }

    public ResourceLocation func_201364_a() {
        return this.field_201373_h;
    }

    @Override
    public void func_186760_a(ServerPlayerEntity serverPlayerEntity) {
        super.func_186760_a(serverPlayerEntity);
        this.field_201374_i.add(serverPlayerEntity.func_110124_au());
    }

    public void func_201372_a(UUID uUID) {
        this.field_201374_i.add(uUID);
    }

    @Override
    public void func_186761_b(ServerPlayerEntity serverPlayerEntity) {
        super.func_186761_b(serverPlayerEntity);
        this.field_201374_i.remove(serverPlayerEntity.func_110124_au());
    }

    @Override
    public void func_201360_b() {
        super.func_201360_b();
        this.field_201374_i.clear();
    }

    public int func_201365_c() {
        return this.field_201375_j;
    }

    public int func_201367_d() {
        return this.field_201376_k;
    }

    public void func_201362_a(int n) {
        this.field_201375_j = n;
        this.func_186735_a(MathHelper.func_76131_a((float)n / (float)this.field_201376_k, 0.0f, 1.0f));
    }

    public void func_201366_b(int n) {
        this.field_201376_k = n;
        this.func_186735_a(MathHelper.func_76131_a((float)this.field_201375_j / (float)n, 0.0f, 1.0f));
    }

    public final ITextComponent func_201369_e() {
        return TextComponentUtils.func_197676_a(this.func_186744_e()).func_211710_a(style -> style.func_150238_a(this.func_186736_g().func_201482_a()).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new StringTextComponent(this.func_201364_a().toString()))).func_179989_a(this.func_201364_a().toString()));
    }

    public boolean func_201368_a(Collection<ServerPlayerEntity> collection2) {
        HashSet hashSet2 = Sets.newHashSet();
        HashSet hashSet = Sets.newHashSet();
        for (UUID uUID : this.field_201374_i) {
            boolean bl = false;
            for (ServerPlayerEntity serverPlayerEntity : collection2) {
                if (!serverPlayerEntity.func_110124_au().equals(uUID)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet2.add(uUID);
        }
        for (ServerPlayerEntity serverPlayerEntity : collection2) {
            boolean bl = false;
            for (UUID uUID : this.field_201374_i) {
                if (!serverPlayerEntity.func_110124_au().equals(uUID)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet.add(serverPlayerEntity);
        }
        for (UUID uUID : hashSet2) {
            for (ServerPlayerEntity serverPlayerEntity : this.func_186757_c()) {
                if (!serverPlayerEntity.func_110124_au().equals(uUID)) continue;
                this.func_186761_b(serverPlayerEntity);
                break;
            }
            this.field_201374_i.remove(uUID);
        }
        for (ServerPlayerEntity serverPlayerEntity : hashSet) {
            this.func_186760_a(serverPlayerEntity);
        }
        return !hashSet2.isEmpty() || !hashSet.isEmpty();
    }

    public CompoundNBT func_201370_f() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("Name", ITextComponent.Serializer.func_150696_a(this.field_186749_a));
        compoundNBT.func_74757_a("Visible", this.func_201359_g());
        compoundNBT.func_74768_a("Value", this.field_201375_j);
        compoundNBT.func_74768_a("Max", this.field_201376_k);
        compoundNBT.func_74778_a("Color", this.func_186736_g().func_201480_b());
        compoundNBT.func_74778_a("Overlay", this.func_186740_h().func_201486_a());
        compoundNBT.func_74757_a("DarkenScreen", this.func_186734_i());
        compoundNBT.func_74757_a("PlayBossMusic", this.func_186747_j());
        compoundNBT.func_74757_a("CreateWorldFog", this.func_186748_k());
        ListNBT \u26032 = new ListNBT();
        for (UUID uUID : this.field_201374_i) {
            \u26032.add(NBTUtil.func_186862_a(uUID));
        }
        compoundNBT.func_218657_a("Players", \u26032);
        return compoundNBT;
    }

    public static CustomServerBossInfo func_201371_a(CompoundNBT compoundNBT, ResourceLocation resourceLocation) {
        CustomServerBossInfo customServerBossInfo = new CustomServerBossInfo(resourceLocation, ITextComponent.Serializer.func_150699_a(compoundNBT.func_74779_i("Name")));
        customServerBossInfo.func_186758_d(compoundNBT.func_74767_n("Visible"));
        customServerBossInfo.func_201362_a(compoundNBT.func_74762_e("Value"));
        customServerBossInfo.func_201366_b(compoundNBT.func_74762_e("Max"));
        customServerBossInfo.func_186745_a(BossInfo.Color.func_201481_a(compoundNBT.func_74779_i("Color")));
        customServerBossInfo.func_186746_a(BossInfo.Overlay.func_201485_a(compoundNBT.func_74779_i("Overlay")));
        customServerBossInfo.func_186741_a(compoundNBT.func_74767_n("DarkenScreen"));
        customServerBossInfo.func_186742_b(compoundNBT.func_74767_n("PlayBossMusic"));
        customServerBossInfo.func_186743_c(compoundNBT.func_74767_n("CreateWorldFog"));
        ListNBT \u26032 = compoundNBT.func_150295_c("Players", 10);
        for (int i = 0; i < \u26032.size(); ++i) {
            customServerBossInfo.func_201372_a(NBTUtil.func_186860_b(\u26032.func_150305_b(i)));
        }
        return customServerBossInfo;
    }

    public void func_201361_c(ServerPlayerEntity serverPlayerEntity) {
        if (this.field_201374_i.contains(serverPlayerEntity.func_110124_au())) {
            this.func_186760_a(serverPlayerEntity);
        }
    }

    public void func_201363_d(ServerPlayerEntity serverPlayerEntity) {
        super.func_186761_b(serverPlayerEntity);
    }
}

