/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;

public class WalkNodeProcessor
extends NodeProcessor {
    protected float field_176183_h;

    @Override
    public void func_225578_a_(Region region, MobEntity mobEntity) {
        super.func_225578_a_(region, mobEntity);
        this.field_176183_h = mobEntity.func_184643_a(PathNodeType.WATER);
    }

    @Override
    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.field_176183_h);
        super.func_176163_a();
    }

    @Override
    public PathPoint func_186318_b() {
        Object \u26033;
        BlockPos \u26032;
        int n;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            n = MathHelper.func_76128_c(this.field_186326_b.func_226278_cu_());
            \u26032 = new BlockPos.Mutable(this.field_186326_b.func_226277_ct_(), (double)n, this.field_186326_b.func_226281_cx_());
            \u26033 = this.field_176169_a.func_180495_p(\u26032);
            while (((BlockState)\u26033).func_177230_c() == Blocks.field_150355_j || ((BlockState)\u26033).func_204520_s() == Fluids.field_204546_a.func_207204_a(false)) {
                ((BlockPos.Mutable)\u26032).func_189532_c(this.field_186326_b.func_226277_ct_(), ++n, this.field_186326_b.func_226281_cx_());
                \u26033 = this.field_176169_a.func_180495_p(\u26032);
            }
            --n;
        } else if (this.field_186326_b.field_70122_E) {
            n = MathHelper.func_76128_c(this.field_186326_b.func_226278_cu_() + 0.5);
        } else {
            \u26032 = new BlockPos(this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(\u26032).func_196958_f() || this.field_176169_a.func_180495_p(\u26032).func_196957_g(this.field_176169_a, \u26032, PathType.LAND)) && \u26032.func_177956_o() > 0) {
                \u26032 = \u26032.func_177977_b();
            }
            n = \u26032.func_177984_a().func_177956_o();
        }
        \u26032 = new BlockPos(this.field_186326_b);
        \u26033 = this.func_186331_a(this.field_186326_b, \u26032.func_177958_n(), n, \u26032.func_177952_p());
        if (this.field_186326_b.func_184643_a((PathNodeType)((Object)\u26033)) < 0.0f) {
            HashSet \u26034 = Sets.newHashSet();
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)n, this.field_186326_b.func_174813_aQ().field_72339_c));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)n, this.field_186326_b.func_174813_aQ().field_72334_f));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)n, this.field_186326_b.func_174813_aQ().field_72339_c));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)n, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockPos : \u26034) {
                PathNodeType pathNodeType = this.func_186329_a(this.field_186326_b, blockPos);
                if (!(this.field_186326_b.func_184643_a(pathNodeType) >= 0.0f)) continue;
                return this.func_176159_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            }
        }
        return this.func_176159_a(\u26032.func_177958_n(), n, \u26032.func_177952_p());
    }

    @Override
    public FlaggedPathPoint func_224768_a(double d, double d2, double d3) {
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3)));
    }

    @Override
    public int func_222859_a(PathPoint[] pathPointArray, PathPoint pathPoint) {
        int \u26033;
        int n = 0;
        \u26033 = 0;
        PathNodeType \u26032 = this.func_186331_a(this.field_186326_b, pathPoint.field_75839_a, pathPoint.field_75837_b + 1, pathPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(\u26032) >= 0.0f) {
            PathNodeType pathNodeType = this.func_186331_a(this.field_186326_b, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
            \u26033 = pathNodeType == PathNodeType.STICKY_HONEY ? 0 : MathHelper.func_76141_d(Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        if ((\u2603 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u26033, \u2603 = WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c)), Direction.SOUTH)) != null && !\u2603.field_75842_i && \u2603.field_186286_l >= 0.0f) {
            pathPointArray[n++] = \u2603;
        }
        if ((\u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u26033, \u2603, Direction.WEST)) != null && !\u2603.field_75842_i && \u2603.field_186286_l >= 0.0f) {
            pathPointArray[n++] = \u2603;
        }
        if ((\u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u26033, \u2603, Direction.EAST)) != null && !\u2603.field_75842_i && \u2603.field_186286_l >= 0.0f) {
            pathPointArray[n++] = \u2603;
        }
        if ((\u2603 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u26033, \u2603, Direction.NORTH)) != null && !\u2603.field_75842_i && \u2603.field_186286_l >= 0.0f) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u26033, \u2603, Direction.NORTH))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u26033, \u2603, Direction.NORTH))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u26033, \u2603, Direction.SOUTH))) {
            pathPointArray[n++] = \u2603;
        }
        if (this.func_222860_a(pathPoint, \u2603, \u2603, \u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u26033, \u2603, Direction.SOUTH))) {
            pathPointArray[n++] = \u2603;
        }
        return n;
    }

    private boolean func_222860_a(PathPoint pathPoint, @Nullable PathPoint pathPoint2, @Nullable PathPoint pathPoint3, @Nullable PathPoint pathPoint4) {
        if (pathPoint4 == null || pathPoint3 == null || pathPoint2 == null) {
            return false;
        }
        if (pathPoint4.field_75842_i) {
            return false;
        }
        if (pathPoint3.field_75837_b > pathPoint.field_75837_b || pathPoint2.field_75837_b > pathPoint.field_75837_b) {
            return false;
        }
        return pathPoint4.field_186286_l >= 0.0f && (pathPoint3.field_75837_b < pathPoint.field_75837_b || pathPoint3.field_186286_l >= 0.0f) && (pathPoint2.field_75837_b < pathPoint.field_75837_b || pathPoint2.field_186286_l >= 0.0f);
    }

    public static double func_197682_a(IBlockReader iBlockReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        VoxelShape voxelShape = iBlockReader.func_180495_p(\u2603).func_196952_d(iBlockReader, \u2603);
        return (double)\u2603.func_177956_o() + (voxelShape.func_197766_b() ? 0.0 : voxelShape.func_197758_c(Direction.Axis.Y));
    }

    @Nullable
    private PathPoint func_186332_a(int n6, int n2, int n3, int n4, double d, Direction direction) {
        PathPoint pathPoint = null;
        BlockPos \u26032 = new BlockPos(n6, n2, n3);
        double \u26033 = WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032);
        if (\u26033 - d > 1.125) {
            return null;
        }
        PathNodeType \u26034 = this.func_186331_a(this.field_186326_b, n6, n2, n3);
        float \u26035 = this.field_186326_b.func_184643_a(\u26034);
        double \u26036 = (double)this.field_186326_b.func_213311_cf() / 2.0;
        if (\u26035 >= 0.0f) {
            pathPoint = this.func_176159_a(n6, n2, n3);
            pathPoint.field_186287_m = \u26034;
            pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
        }
        if (\u26034 == PathNodeType.WALKABLE) {
            return pathPoint;
        }
        if (!(pathPoint != null && !(pathPoint.field_186286_l < 0.0f) || n4 <= 0 || \u26034 == PathNodeType.FENCE || \u26034 == PathNodeType.TRAPDOOR || (pathPoint = this.func_186332_a(n6, n2 + 1, n3, n4 - 1, d, direction)) == null || pathPoint.field_186287_m != PathNodeType.OPEN && pathPoint.field_186287_m != PathNodeType.WALKABLE || !(this.field_186326_b.func_213311_cf() < 1.0f) || this.field_176169_a.func_226665_a__(this.field_186326_b, \u2603 = new AxisAlignedBB((\u2603 = (double)(n6 - direction.func_82601_c()) + 0.5) - \u26036, WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(\u2603, (double)(n2 + 1), \u2603 = (double)(n3 - direction.func_82599_e()) + 0.5)) + 0.001, \u2603 - \u26036, \u2603 + \u26036, (double)this.field_186326_b.func_213302_cg() + WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c)) - 0.002, \u2603 + \u26036)))) {
            pathPoint = null;
        }
        if (\u26034 == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.func_186331_a(this.field_186326_b, n6, n2 - 1, n3) != PathNodeType.WATER) {
                return pathPoint;
            }
            while (n2 > 0) {
                if ((\u26034 = this.func_186331_a(this.field_186326_b, n6, --n2, n3)) == PathNodeType.WATER) {
                    pathPoint = this.func_176159_a(n6, n2, n3);
                    pathPoint.field_186287_m = \u26034;
                    pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, this.field_186326_b.func_184643_a(\u26034));
                    continue;
                }
                return pathPoint;
            }
        }
        if (\u26034 == PathNodeType.OPEN) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)n6 - \u26036 + 0.5, (double)n2 + 0.001, (double)n3 - \u26036 + 0.5, (double)n6 + \u26036 + 0.5, (float)n2 + this.field_186326_b.func_213302_cg(), (double)n3 + \u26036 + 0.5);
            if (!this.field_176169_a.func_226665_a__(this.field_186326_b, axisAlignedBB)) {
                return null;
            }
            if (this.field_186326_b.func_213311_cf() >= 1.0f && (\u2603 = this.func_186331_a(this.field_186326_b, n6, n2 - 1, n3)) == PathNodeType.BLOCKED) {
                pathPoint = this.func_176159_a(n6, n2, n3);
                pathPoint.field_186287_m = PathNodeType.WALKABLE;
                pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
                return pathPoint;
            }
            int n5 = 0;
            \u2603 = n2;
            while (\u26034 == PathNodeType.OPEN) {
                int n6;
                PathPoint \u26037;
                if (--n2 < 0) {
                    \u26037 = this.func_176159_a(n6, \u2603, n3);
                    \u26037.field_186287_m = PathNodeType.BLOCKED;
                    \u26037.field_186286_l = -1.0f;
                    return \u26037;
                }
                \u26037 = this.func_176159_a(n6, n2, n3);
                if (n5++ >= this.field_186326_b.func_82143_as()) {
                    \u26037.field_186287_m = PathNodeType.BLOCKED;
                    \u26037.field_186286_l = -1.0f;
                    return \u26037;
                }
                \u26034 = this.func_186331_a(this.field_186326_b, n6, n2, n3);
                \u26035 = this.field_186326_b.func_184643_a(\u26034);
                if (\u26034 != PathNodeType.OPEN && \u26035 >= 0.0f) {
                    pathPoint = \u26037;
                    pathPoint.field_186287_m = \u26034;
                    pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
                    break;
                }
                if (!(\u26035 < 0.0f)) continue;
                \u26037.field_186287_m = PathNodeType.BLOCKED;
                \u26037.field_186286_l = -1.0f;
                return \u26037;
            }
        }
        return pathPoint;
    }

    @Override
    public PathNodeType func_186319_a(IBlockReader iBlockReader, int n, int n2, int n3, MobEntity mobEntity2, int n4, int n5, int n6, boolean bl, boolean bl2) {
        MobEntity mobEntity2;
        EnumSet<PathNodeType> enumSet = EnumSet.noneOf(PathNodeType.class);
        PathNodeType \u26032 = PathNodeType.BLOCKED;
        double \u26033 = (double)mobEntity2.func_213311_cf() / 2.0;
        BlockPos \u26034 = new BlockPos(mobEntity2);
        \u26032 = this.func_193577_a(iBlockReader, n, n2, n3, n4, n5, n6, bl, bl2, enumSet, \u26032, \u26034);
        if (enumSet.contains((Object)PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType \u26035 = PathNodeType.BLOCKED;
        for (PathNodeType pathNodeType : enumSet) {
            if (mobEntity2.func_184643_a(pathNodeType) < 0.0f) {
                return pathNodeType;
            }
            if (!(mobEntity2.func_184643_a(pathNodeType) >= mobEntity2.func_184643_a(\u26035))) continue;
            \u26035 = pathNodeType;
        }
        if (\u26032 == PathNodeType.OPEN && mobEntity2.func_184643_a(\u26035) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return \u26035;
    }

    public PathNodeType func_193577_a(IBlockReader iBlockReader, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, EnumSet<PathNodeType> enumSet, PathNodeType pathNodeType2, BlockPos blockPos) {
        PathNodeType pathNodeType2;
        for (int i = 0; i < n4; ++i) {
            for (\u2603 = 0; \u2603 < n5; ++\u2603) {
                for (\u2603 = 0; \u2603 < n6; ++\u2603) {
                    \u2603 = i + n;
                    \u2603 = \u2603 + n2;
                    \u2603 = \u2603 + n3;
                    PathNodeType pathNodeType3 = this.func_186330_a(iBlockReader, \u2603, \u2603, \u2603);
                    pathNodeType3 = this.func_215744_a(iBlockReader, bl, bl2, blockPos, pathNodeType3);
                    if (i == 0 && \u2603 == 0 && \u2603 == 0) {
                        pathNodeType2 = pathNodeType3;
                    }
                    enumSet.add(pathNodeType3);
                }
            }
        }
        return pathNodeType2;
    }

    protected PathNodeType func_215744_a(IBlockReader iBlockReader, boolean bl, boolean bl2, BlockPos blockPos, PathNodeType pathNodeType) {
        if (pathNodeType == PathNodeType.DOOR_WOOD_CLOSED && bl && bl2) {
            pathNodeType = PathNodeType.WALKABLE;
        }
        if (pathNodeType == PathNodeType.DOOR_OPEN && !bl2) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        if (pathNodeType == PathNodeType.RAIL && !(iBlockReader.func_180495_p(blockPos).func_177230_c() instanceof AbstractRailBlock) && !(iBlockReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() instanceof AbstractRailBlock)) {
            pathNodeType = PathNodeType.FENCE;
        }
        if (pathNodeType == PathNodeType.LEAVES) {
            pathNodeType = PathNodeType.BLOCKED;
        }
        return pathNodeType;
    }

    private PathNodeType func_186329_a(MobEntity mobEntity, BlockPos blockPos) {
        return this.func_186331_a(mobEntity, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    private PathNodeType func_186331_a(MobEntity mobEntity, int n, int n2, int n3) {
        return this.func_186319_a(this.field_176169_a, n, n2, n3, mobEntity, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    @Override
    public PathNodeType func_186330_a(IBlockReader iBlockReader, int n, int n2, int n3) {
        return WalkNodeProcessor.func_227480_b_(iBlockReader, n, n2, n3);
    }

    public static PathNodeType func_227480_b_(IBlockReader iBlockReader, int n, int n2, int n3) {
        PathNodeType pathNodeType = WalkNodeProcessor.func_189553_b(iBlockReader, n, n2, n3);
        if (pathNodeType == PathNodeType.OPEN && n2 >= 1) {
            Block block = iBlockReader.func_180495_p(new BlockPos(n, n2 - 1, n3)).func_177230_c();
            PathNodeType \u26032 = WalkNodeProcessor.func_189553_b(iBlockReader, n, n2 - 1, n3);
            PathNodeType pathNodeType2 = pathNodeType = \u26032 == PathNodeType.WALKABLE || \u26032 == PathNodeType.OPEN || \u26032 == PathNodeType.WATER || \u26032 == PathNodeType.LAVA ? PathNodeType.OPEN : PathNodeType.WALKABLE;
            if (\u26032 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ || block == Blocks.field_222433_lV) {
                pathNodeType = PathNodeType.DAMAGE_FIRE;
            }
            if (\u26032 == PathNodeType.DAMAGE_CACTUS) {
                pathNodeType = PathNodeType.DAMAGE_CACTUS;
            }
            if (\u26032 == PathNodeType.DAMAGE_OTHER) {
                pathNodeType = PathNodeType.DAMAGE_OTHER;
            }
            if (\u26032 == PathNodeType.STICKY_HONEY) {
                pathNodeType = PathNodeType.STICKY_HONEY;
            }
        }
        if (pathNodeType == PathNodeType.WALKABLE) {
            pathNodeType = WalkNodeProcessor.func_193578_a(iBlockReader, n, n2, n3, pathNodeType);
        }
        return pathNodeType;
    }

    public static PathNodeType func_193578_a(IBlockReader iBlockReader, int n, int n2, int n3, PathNodeType \u260322) {
        PathNodeType \u260322;
        try (BlockPos.PooledMutable pooledMutable = BlockPos.PooledMutable.func_185346_s();){
            for (int i = -1; i <= 1; ++i) {
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                        if (i == 0 && \u2603 == 0) continue;
                        Block block = iBlockReader.func_180495_p(pooledMutable.func_181079_c(i + n, \u2603 + n2, \u2603 + n3)).func_177230_c();
                        if (block == Blocks.field_150434_aF) {
                            \u260322 = PathNodeType.DANGER_CACTUS;
                            continue;
                        }
                        if (block == Blocks.field_150480_ab || block == Blocks.field_150353_l) {
                            \u260322 = PathNodeType.DANGER_FIRE;
                            continue;
                        }
                        if (block != Blocks.field_222434_lW) continue;
                        \u260322 = PathNodeType.DANGER_OTHER;
                    }
                }
            }
        }
        return \u260322;
    }

    protected static PathNodeType func_189553_b(IBlockReader iBlockReader, int n, int n2, int n3) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        BlockState \u26032 = iBlockReader.func_180495_p(blockPos);
        Block \u26033 = \u26032.func_177230_c();
        Material \u26034 = \u26032.func_185904_a();
        if (\u26032.func_196958_f()) {
            return PathNodeType.OPEN;
        }
        if (\u26033.func_203417_a(BlockTags.field_212185_E) || \u26033 == Blocks.field_196651_dG) {
            return PathNodeType.TRAPDOOR;
        }
        if (\u26033 == Blocks.field_150480_ab) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (\u26033 == Blocks.field_150434_aF) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (\u26033 == Blocks.field_222434_lW) {
            return PathNodeType.DAMAGE_OTHER;
        }
        if (\u26033 == Blocks.field_226907_mc_) {
            return PathNodeType.STICKY_HONEY;
        }
        if (\u26033 == Blocks.field_150375_by) {
            return PathNodeType.COCOA;
        }
        if (\u26033 instanceof DoorBlock && \u26034 == Material.field_151575_d && !\u26032.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_WOOD_CLOSED;
        }
        if (\u26033 instanceof DoorBlock && \u26034 == Material.field_151573_f && !\u26032.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_IRON_CLOSED;
        }
        if (\u26033 instanceof DoorBlock && \u26032.func_177229_b(DoorBlock.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_OPEN;
        }
        if (\u26033 instanceof AbstractRailBlock) {
            return PathNodeType.RAIL;
        }
        if (\u26033 instanceof LeavesBlock) {
            return PathNodeType.LEAVES;
        }
        if (\u26033.func_203417_a(BlockTags.field_219748_G) || \u26033.func_203417_a(BlockTags.field_219757_z) || \u26033 instanceof FenceGateBlock && !\u26032.func_177229_b(FenceGateBlock.field_176466_a).booleanValue()) {
            return PathNodeType.FENCE;
        }
        IFluidState \u26035 = iBlockReader.func_204610_c(blockPos);
        if (\u26035.func_206884_a(FluidTags.field_206959_a)) {
            return PathNodeType.WATER;
        }
        if (\u26035.func_206884_a(FluidTags.field_206960_b)) {
            return PathNodeType.LAVA;
        }
        if (\u26032.func_196957_g(iBlockReader, blockPos, PathType.LAND)) {
            return PathNodeType.OPEN;
        }
        return PathNodeType.BLOCKED;
    }
}

