/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TurtleEntity
extends AnimalEntity {
    private static final DataParameter<BlockPos> field_203030_by = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203031_bz = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203024_bB = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> field_203025_bC = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203026_bD = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203027_bE = EntityDataManager.func_187226_a(TurtleEntity.class, DataSerializers.field_187198_h);
    private int field_203028_bF;
    public static final Predicate<LivingEntity> field_203029_bx = livingEntity -> livingEntity.func_70631_g_() && !livingEntity.func_70090_H();

    public TurtleEntity(EntityType<? extends TurtleEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public void func_203011_g(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_203030_by, blockPos);
    }

    private BlockPos func_203018_dA() {
        return this.field_70180_af.func_187225_a(field_203030_by);
    }

    private void func_203019_h(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_203025_bC, blockPos);
    }

    private BlockPos func_203013_dB() {
        return this.field_70180_af.func_187225_a(field_203025_bC);
    }

    public boolean func_203020_dx() {
        return this.field_70180_af.func_187225_a(field_203031_bz);
    }

    private void func_203017_r(boolean bl) {
        this.field_70180_af.func_187227_b(field_203031_bz, bl);
    }

    public boolean func_203023_dy() {
        return this.field_70180_af.func_187225_a(field_203024_bB);
    }

    private void func_203015_s(boolean bl) {
        this.field_203028_bF = bl ? 1 : 0;
        this.field_70180_af.func_187227_b(field_203024_bB, bl);
    }

    private boolean func_203022_dF() {
        return this.field_70180_af.func_187225_a(field_203026_bD);
    }

    private void func_203012_t(boolean bl) {
        this.field_70180_af.func_187227_b(field_203026_bD, bl);
    }

    private boolean func_203014_dG() {
        return this.field_70180_af.func_187225_a(field_203027_bE);
    }

    private void func_203021_u(boolean bl) {
        this.field_70180_af.func_187227_b(field_203027_bE, bl);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203030_by, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203031_bz, false);
        this.field_70180_af.func_187214_a(field_203025_bC, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203026_bD, false);
        this.field_70180_af.func_187214_a(field_203027_bE, false);
        this.field_70180_af.func_187214_a(field_203024_bB, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("HomePosX", this.func_203018_dA().func_177958_n());
        compoundNBT.func_74768_a("HomePosY", this.func_203018_dA().func_177956_o());
        compoundNBT.func_74768_a("HomePosZ", this.func_203018_dA().func_177952_p());
        compoundNBT.func_74757_a("HasEgg", this.func_203020_dx());
        compoundNBT.func_74768_a("TravelPosX", this.func_203013_dB().func_177958_n());
        compoundNBT.func_74768_a("TravelPosY", this.func_203013_dB().func_177956_o());
        compoundNBT.func_74768_a("TravelPosZ", this.func_203013_dB().func_177952_p());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        int n = compoundNBT.func_74762_e("HomePosX");
        \u2603 = compoundNBT.func_74762_e("HomePosY");
        \u2603 = compoundNBT.func_74762_e("HomePosZ");
        this.func_203011_g(new BlockPos(n, \u2603, \u2603));
        super.func_70037_a(compoundNBT);
        this.func_203017_r(compoundNBT.func_74767_n("HasEgg"));
        \u2603 = compoundNBT.func_74762_e("TravelPosX");
        \u2603 = compoundNBT.func_74762_e("TravelPosY");
        \u2603 = compoundNBT.func_74762_e("TravelPosZ");
        this.func_203019_h(new BlockPos(\u2603, \u2603, \u2603));
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_203011_g(new BlockPos(this));
        this.func_203019_h(BlockPos.field_177992_a);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    public static boolean func_223322_c(EntityType<TurtleEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return blockPos.func_177956_o() < iWorld.func_181545_F() + 4 && iWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_150354_m && iWorld.func_226659_b_(blockPos, 0) > 8;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new PanicGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(1, new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new PlayerTemptGoal(this, 1.1, Blocks.field_203198_aQ.func_199767_j()));
        this.field_70714_bg.func_75776_a(3, new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new GoHomeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new TravelGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, new WanderGoal(this, 1.0, 100));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    public int func_70627_aG() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (!this.func_70090_H() && this.field_70122_E && !this.func_70631_g_()) {
            return SoundEvents.field_203277_iv;
        }
        return super.func_184639_G();
    }

    @Override
    protected void func_203006_d(float f) {
        super.func_203006_d(f * 1.5f);
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203265_iE;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_70631_g_()) {
            return SoundEvents.field_203262_iB;
        }
        return SoundEvents.field_203261_iA;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        if (this.func_70631_g_()) {
            return SoundEvents.field_203264_iD;
        }
        return SoundEvents.field_203263_iC;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        SoundEvent soundEvent = this.func_70631_g_() ? SoundEvents.field_203267_iG : SoundEvents.field_203266_iF;
        this.func_184185_a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.func_203020_dx();
    }

    @Override
    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    @Override
    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.3f : 1.0f;
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new Navigator(this, world);
    }

    @Override
    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return EntityType.field_203099_aq.func_200721_a(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Blocks.field_203198_aQ.func_199767_j();
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (!this.func_203022_dF() && iWorldReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a)) {
            return 10.0f;
        }
        if (iWorldReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
            return 10.0f;
        }
        return iWorldReader.func_205052_D(blockPos) - 0.5f;
    }

    @Override
    public void func_70636_d() {
        BlockPos blockPos;
        super.func_70636_d();
        if (this.func_70089_S() && this.func_203023_dy() && this.field_203028_bF >= 1 && this.field_203028_bF % 5 == 0 && this.field_70170_p.func_180495_p((blockPos = new BlockPos(this)).func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
            this.field_70170_p.func_217379_c(2001, blockPos, Block.func_196246_j(Blocks.field_150354_m.func_176223_P()));
        }
    }

    @Override
    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199702_a(Items.field_203183_eM, 1);
        }
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!(this.func_70638_az() != null || this.func_203022_dF() && this.func_203018_dA().func_218137_a(this.func_213303_ch(), 20.0))) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return false;
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        this.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
    }

    static class Navigator
    extends SwimmerPathNavigator {
        Navigator(TurtleEntity turtleEntity, World world) {
            super(turtleEntity, world);
        }

        @Override
        protected boolean func_75485_k() {
            return true;
        }

        @Override
        protected PathFinder func_179679_a(int n) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, n);
        }

        @Override
        public boolean func_188555_b(BlockPos blockPos) {
            if (this.field_75515_a instanceof TurtleEntity && (\u2603 = (TurtleEntity)this.field_75515_a).func_203014_dG()) {
                return this.field_75513_b.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j;
            }
            return !this.field_75513_b.func_180495_p(blockPos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final TurtleEntity field_203103_i;

        MoveHelperController(TurtleEntity turtleEntity) {
            super(turtleEntity);
            this.field_203103_i = turtleEntity;
        }

        private void func_203102_g() {
            if (this.field_203103_i.func_70090_H()) {
                this.field_203103_i.func_213317_d(this.field_203103_i.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (!this.field_203103_i.func_203018_dA().func_218137_a(this.field_203103_i.func_213303_ch(), 16.0)) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.08f));
                }
                if (this.field_203103_i.func_70631_g_()) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.field_203103_i.field_70122_E) {
                this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        @Override
        public void func_75641_c() {
            this.func_203102_g();
            if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_203103_i.func_70661_as().func_75500_f()) {
                this.field_203103_i.func_70659_e(0.0f);
                return;
            }
            double d = this.field_75646_b - this.field_203103_i.func_226277_ct_();
            \u2603 = this.field_75647_c - this.field_203103_i.func_226278_cu_();
            \u2603 = this.field_75644_d - this.field_203103_i.func_226281_cx_();
            \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603);
            float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
            this.field_203103_i.field_70761_aq = this.field_203103_i.field_70177_z = this.func_75639_a(this.field_203103_i.field_70177_z, \u26032, 90.0f);
            float \u26033 = (float)(this.field_75645_e * this.field_203103_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            this.field_203103_i.func_70659_e(MathHelper.func_219799_g(0.125f, this.field_203103_i.func_70689_ay(), \u26033));
            this.field_203103_i.func_213317_d(this.field_203103_i.func_213322_ci().func_72441_c(0.0, (double)this.field_203103_i.func_70689_ay() * (\u2603 /= \u2603) * 0.1, 0.0));
        }
    }

    static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final TurtleEntity field_203121_f;

        private GoToWaterGoal(TurtleEntity turtleEntity, double d) {
            super(turtleEntity, turtleEntity.func_70631_g_() ? 2.0 : d, 24);
            this.field_203121_f = turtleEntity;
            this.field_203112_e = -1;
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_203121_f.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a(this.field_203121_f.field_70170_p, this.field_179494_b);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203121_f.func_70631_g_() && !this.field_203121_f.func_70090_H()) {
                return super.func_75250_a();
            }
            if (!(this.field_203121_f.func_203022_dF() || this.field_203121_f.func_70090_H() || this.field_203121_f.func_203020_dx())) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        @Override
        protected boolean func_179488_a(IWorldReader iWorldReader, BlockPos blockPos) {
            Block block = iWorldReader.func_180495_p(blockPos).func_177230_c();
            return block == Blocks.field_150355_j;
        }
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final TurtleEntity field_203123_h;

        private WanderGoal(TurtleEntity turtleEntity, double d, int n) {
            super(turtleEntity, d, n);
            this.field_203123_h = turtleEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (!(this.field_75457_a.func_70090_H() || this.field_203123_h.func_203022_dF() || this.field_203123_h.func_203020_dx())) {
                return super.func_75250_a();
            }
            return false;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final TurtleEntity field_203122_f;

        LayEggGoal(TurtleEntity turtleEntity, double d) {
            super(turtleEntity, d, 16);
            this.field_203122_f = turtleEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203122_f.func_203020_dx() && this.field_203122_f.func_203018_dA().func_218137_a(this.field_203122_f.func_213303_ch(), 9.0)) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_203122_f.func_203020_dx() && this.field_203122_f.func_203018_dA().func_218137_a(this.field_203122_f.func_213303_ch(), 9.0);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockPos = new BlockPos(this.field_203122_f);
            if (!this.field_203122_f.func_70090_H() && this.func_179487_f()) {
                if (this.field_203122_f.field_203028_bF < 1) {
                    this.field_203122_f.func_203015_s(true);
                } else if (this.field_203122_f.field_203028_bF > 200) {
                    World world = this.field_203122_f.field_70170_p;
                    world.func_184133_a(null, blockPos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)Blocks.field_203213_jA.func_176223_P().func_206870_a(TurtleEggBlock.field_203171_b, this.field_203122_f.field_70146_Z.nextInt(4) + 1), 3);
                    this.field_203122_f.func_203017_r(false);
                    this.field_203122_f.func_203015_s(false);
                    this.field_203122_f.func_204700_e(600);
                }
                if (this.field_203122_f.func_203023_dy()) {
                    this.field_203122_f.field_203028_bF++;
                }
            }
        }

        @Override
        protected boolean func_179488_a(IWorldReader iWorldReader, BlockPos blockPos) {
            if (!iWorldReader.func_175623_d(blockPos.func_177984_a())) {
                return false;
            }
            Block block = iWorldReader.func_180495_p(blockPos).func_177230_c();
            return block == Blocks.field_150354_m;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final TurtleEntity field_203107_f;

        MateGoal(TurtleEntity turtleEntity, double d) {
            super(turtleEntity, d);
            this.field_203107_f = turtleEntity;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_203107_f.func_203020_dx();
        }

        @Override
        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, null);
            }
            this.field_203107_f.func_203017_r(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random \u26032 = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c(new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), \u26032.nextInt(7) + 1));
            }
        }
    }

    static class PlayerTemptGoal
    extends Goal {
        private static final EntityPredicate field_220834_a = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a();
        private final TurtleEntity field_203132_a;
        private final double field_203133_b;
        private PlayerEntity field_203134_c;
        private int field_203135_d;
        private final Set<Item> field_203136_e;

        PlayerTemptGoal(TurtleEntity turtleEntity, double d, Item item) {
            this.field_203132_a = turtleEntity;
            this.field_203133_b = d;
            this.field_203136_e = Sets.newHashSet((Object[])new Item[]{item});
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203135_d > 0) {
                --this.field_203135_d;
                return false;
            }
            this.field_203134_c = this.field_203132_a.field_70170_p.func_217370_a(field_220834_a, this.field_203132_a);
            if (this.field_203134_c == null) {
                return false;
            }
            return this.func_203131_a(this.field_203134_c.func_184614_ca()) || this.func_203131_a(this.field_203134_c.func_184592_cb());
        }

        private boolean func_203131_a(ItemStack itemStack) {
            return this.field_203136_e.contains(itemStack.func_77973_b());
        }

        @Override
        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        @Override
        public void func_75251_c() {
            this.field_203134_c = null;
            this.field_203132_a.func_70661_as().func_75499_g();
            this.field_203135_d = 100;
        }

        @Override
        public void func_75246_d() {
            this.field_203132_a.func_70671_ap().func_75651_a(this.field_203134_c, this.field_203132_a.func_184649_cE() + 20, this.field_203132_a.func_70646_bf());
            if (this.field_203132_a.func_70068_e(this.field_203134_c) < 6.25) {
                this.field_203132_a.func_70661_as().func_75499_g();
            } else {
                this.field_203132_a.func_70661_as().func_75497_a(this.field_203134_c, this.field_203133_b);
            }
        }
    }

    static class GoHomeGoal
    extends Goal {
        private final TurtleEntity field_203127_a;
        private final double field_203128_b;
        private boolean field_203129_c;
        private int field_203130_d;

        GoHomeGoal(TurtleEntity turtleEntity, double d) {
            this.field_203127_a = turtleEntity;
            this.field_203128_b = d;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203127_a.func_70631_g_()) {
                return false;
            }
            if (this.field_203127_a.func_203020_dx()) {
                return true;
            }
            if (this.field_203127_a.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return !this.field_203127_a.func_203018_dA().func_218137_a(this.field_203127_a.func_213303_ch(), 64.0);
        }

        @Override
        public void func_75249_e() {
            this.field_203127_a.func_203012_t(true);
            this.field_203129_c = false;
            this.field_203130_d = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_203127_a.func_203012_t(false);
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_203127_a.func_203018_dA().func_218137_a(this.field_203127_a.func_213303_ch(), 7.0) && !this.field_203129_c && this.field_203130_d <= 600;
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = this.field_203127_a.func_203018_dA();
            boolean \u26032 = blockPos.func_218137_a(this.field_203127_a.func_213303_ch(), 16.0);
            if (\u26032) {
                ++this.field_203130_d;
            }
            if (this.field_203127_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d = new Vec3d(blockPos);
                \u2603 = RandomPositionGenerator.func_203155_a(this.field_203127_a, 16, 3, vec3d, 0.3141592741012573);
                if (\u2603 == null) {
                    \u2603 = RandomPositionGenerator.func_75464_a(this.field_203127_a, 8, 7, vec3d);
                }
                if (\u2603 != null && !\u26032 && this.field_203127_a.field_70170_p.func_180495_p(new BlockPos(\u2603)).func_177230_c() != Blocks.field_150355_j) {
                    \u2603 = RandomPositionGenerator.func_75464_a(this.field_203127_a, 16, 5, vec3d);
                }
                if (\u2603 == null) {
                    this.field_203129_c = true;
                    return;
                }
                this.field_203127_a.func_70661_as().func_75492_a(\u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, this.field_203128_b);
            }
        }
    }

    static class TravelGoal
    extends Goal {
        private final TurtleEntity field_203137_a;
        private final double field_203138_b;
        private boolean field_203139_c;

        TravelGoal(TurtleEntity turtleEntity, double d) {
            this.field_203137_a = turtleEntity;
            this.field_203138_b = d;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_203020_dx() && this.field_203137_a.func_70090_H();
        }

        @Override
        public void func_75249_e() {
            int n = 512;
            \u2603 = 4;
            Random \u26032 = this.field_203137_a.field_70146_Z;
            \u2603 = \u26032.nextInt(1025) - 512;
            \u2603 = \u26032.nextInt(9) - 4;
            \u2603 = \u26032.nextInt(1025) - 512;
            if ((double)\u2603 + this.field_203137_a.func_226278_cu_() > (double)(this.field_203137_a.field_70170_p.func_181545_F() - 1)) {
                \u2603 = 0;
            }
            BlockPos \u26033 = new BlockPos((double)\u2603 + this.field_203137_a.func_226277_ct_(), (double)\u2603 + this.field_203137_a.func_226278_cu_(), (double)\u2603 + this.field_203137_a.func_226281_cx_());
            this.field_203137_a.func_203019_h(\u26033);
            this.field_203137_a.func_203021_u(true);
            this.field_203139_c = false;
        }

        @Override
        public void func_75246_d() {
            if (this.field_203137_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d;
                Vec3d vec3d2 = new Vec3d(this.field_203137_a.func_203013_dB());
                vec3d = RandomPositionGenerator.func_203155_a(this.field_203137_a, 16, 3, vec3d2, 0.3141592741012573);
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_203137_a, 8, 7, vec3d2);
                }
                if (vec3d != null) {
                    int n = MathHelper.func_76128_c(vec3d.field_72450_a);
                    \u2603 = MathHelper.func_76128_c(vec3d.field_72449_c);
                    \u2603 = 34;
                    if (!this.field_203137_a.field_70170_p.func_217344_a(n - 34, 0, \u2603 - 34, n + 34, 0, \u2603 + 34)) {
                        vec3d = null;
                    }
                }
                if (vec3d == null) {
                    this.field_203139_c = true;
                    return;
                }
                this.field_203137_a.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_203138_b);
            }
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_203137_a.func_70661_as().func_75500_f() && !this.field_203139_c && !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_70880_s() && !this.field_203137_a.func_203020_dx();
        }

        @Override
        public void func_75251_c() {
            this.field_203137_a.func_203021_u(false);
            super.func_75251_c();
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        PanicGoal(TurtleEntity turtleEntity, double d) {
            super(turtleEntity, d);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75267_a.func_70643_av() == null && !this.field_75267_a.func_70027_ad()) {
                return false;
            }
            BlockPos blockPos = this.func_188497_a(this.field_75267_a.field_70170_p, this.field_75267_a, 7, 4);
            if (blockPos != null) {
                this.field_75266_c = blockPos.func_177958_n();
                this.field_75263_d = blockPos.func_177956_o();
                this.field_75264_e = blockPos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }
    }
}

