/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IDynamicSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class Brain<E extends LivingEntity>
implements IDynamicSerializable {
    private final Map<MemoryModuleType<?>, Optional<?>> field_218230_a = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> field_218231_b = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<Task<? super E>>>> field_218232_c = Maps.newTreeMap();
    private Schedule field_218233_d = Schedule.field_221383_a;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>> field_218234_e = Maps.newHashMap();
    private Set<Activity> field_218235_f = Sets.newHashSet();
    private final Set<Activity> field_218236_g = Sets.newHashSet();
    private Activity field_218237_h = Activity.field_221366_b;
    private long field_218238_i = -9999L;

    public <T> Brain(Collection<MemoryModuleType<?>> collection, Collection<SensorType<? extends Sensor<? super E>>> collection2, Dynamic<T> dynamic) {
        collection.forEach(memoryModuleType -> this.field_218230_a.put((MemoryModuleType<?>)memoryModuleType, Optional.empty()));
        collection2.forEach(sensorType -> this.field_218231_b.put((SensorType<Sensor<E>>)sensorType, (Sensor<E>)sensorType.func_220995_a()));
        this.field_218231_b.values().forEach(sensor -> {
            for (MemoryModuleType<?> memoryModuleType : sensor.func_220974_a()) {
                this.field_218230_a.put(memoryModuleType, Optional.empty());
            }
        });
        for (Map.Entry entry : dynamic.get("memories").asMap(Function.identity(), Function.identity()).entrySet()) {
            this.func_218216_a(Registry.field_218372_N.func_82594_a(new ResourceLocation(((Dynamic)entry.getKey()).asString(""))), (Dynamic)entry.getValue());
        }
    }

    public boolean func_218191_a(MemoryModuleType<?> memoryModuleType) {
        return this.func_218196_a(memoryModuleType, MemoryModuleStatus.VALUE_PRESENT);
    }

    private <T, U> void func_218216_a(MemoryModuleType<U> memoryModuleType, Dynamic<T> dynamic) {
        this.func_218205_a(memoryModuleType, memoryModuleType.func_220938_b().orElseThrow(RuntimeException::new).apply(dynamic));
    }

    public <U> void func_218189_b(MemoryModuleType<U> memoryModuleType) {
        this.func_218226_a(memoryModuleType, Optional.empty());
    }

    public <U> void func_218205_a(MemoryModuleType<U> memoryModuleType, @Nullable U u) {
        this.func_218226_a(memoryModuleType, Optional.ofNullable(u));
    }

    public <U> void func_218226_a(MemoryModuleType<U> memoryModuleType, Optional<U> optional) {
        if (this.field_218230_a.containsKey(memoryModuleType)) {
            if (optional.isPresent() && this.func_218213_a(optional.get())) {
                this.func_218189_b(memoryModuleType);
            } else {
                this.field_218230_a.put(memoryModuleType, optional);
            }
        }
    }

    public <U> Optional<U> func_218207_c(MemoryModuleType<U> memoryModuleType) {
        return this.field_218230_a.get(memoryModuleType);
    }

    public boolean func_218196_a(MemoryModuleType<?> memoryModuleType, MemoryModuleStatus memoryModuleStatus) {
        Optional<?> optional = this.field_218230_a.get(memoryModuleType);
        if (optional == null) {
            return false;
        }
        return memoryModuleStatus == MemoryModuleStatus.REGISTERED || memoryModuleStatus == MemoryModuleStatus.VALUE_PRESENT && optional.isPresent() || memoryModuleStatus == MemoryModuleStatus.VALUE_ABSENT && !optional.isPresent();
    }

    public Schedule func_218198_b() {
        return this.field_218233_d;
    }

    public void func_218203_a(Schedule schedule) {
        this.field_218233_d = schedule;
    }

    public void func_218199_a(Set<Activity> set) {
        this.field_218235_f = set;
    }

    @Deprecated
    public Stream<Task<? super E>> func_218193_d() {
        return this.field_218232_c.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(task -> task.func_220376_b() == Task.Status.RUNNING);
    }

    public void func_218202_a(Activity activity) {
        this.field_218236_g.clear();
        this.field_218236_g.addAll(this.field_218235_f);
        boolean bl = this.field_218234_e.keySet().contains(activity) && this.func_218217_d(activity);
        this.field_218236_g.add(bl ? activity : this.field_218237_h);
    }

    public void func_218211_a(long l, long l2) {
        if (l2 - this.field_218238_i > 20L) {
            this.field_218238_i = l2;
            Activity activity = this.func_218198_b().func_221377_a((int)(l % 24000L));
            if (!this.field_218236_g.contains(activity)) {
                this.func_218202_a(activity);
            }
        }
    }

    public void func_218200_b(Activity activity) {
        this.field_218237_h = activity;
    }

    public void func_218208_a(Activity activity, ImmutableList<Pair<Integer, ? extends Task<? super E>>> immutableList) {
        this.func_218224_a(activity, immutableList, (Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>)ImmutableSet.of());
    }

    public void func_218224_a(Activity activity, ImmutableList<Pair<Integer, ? extends Task<? super E>>> immutableList, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> set) {
        this.field_218234_e.put(activity, set);
        immutableList.forEach(pair -> this.field_218232_c.computeIfAbsent((Integer)pair.getFirst(), n -> Maps.newHashMap()).computeIfAbsent(activity, activity -> Sets.newLinkedHashSet()).add(pair.getSecond()));
    }

    public boolean func_218214_c(Activity activity) {
        return this.field_218236_g.contains(activity);
    }

    public Brain<E> func_218185_f() {
        Brain<E> brain = new Brain<E>(this.field_218230_a.keySet(), this.field_218231_b.keySet(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
        this.field_218230_a.forEach((memoryModuleType, optional) -> optional.ifPresent(object -> brain.field_218230_a.put((MemoryModuleType<?>)memoryModuleType, Optional.of(object))));
        return brain;
    }

    public void func_218210_a(ServerWorld serverWorld, E e) {
        this.func_218229_c(serverWorld, e);
        this.func_218218_d(serverWorld, e);
        this.func_218222_e(serverWorld, e);
    }

    public void func_218227_b(ServerWorld serverWorld, E e) {
        long l = ((LivingEntity)e).field_70170_p.func_82737_E();
        this.func_218193_d().forEach(task -> task.func_220380_e(serverWorld, e, l));
    }

    @Override
    public <T> T func_218175_a(DynamicOps<T> dynamicOps) {
        Object object = dynamicOps.createMap(this.field_218230_a.entrySet().stream().filter(entry -> ((MemoryModuleType)entry.getKey()).func_220938_b().isPresent() && ((Optional)entry.getValue()).isPresent()).map(entry -> Pair.of((Object)dynamicOps.createString(Registry.field_218372_N.func_177774_c((MemoryModuleType<?>)entry.getKey()).toString()), ((IDynamicSerializable)((Optional)entry.getValue()).get()).func_218175_a(dynamicOps))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("memories"), (Object)object));
    }

    private void func_218229_c(ServerWorld serverWorld, E e) {
        this.field_218231_b.values().forEach(sensor -> sensor.func_220973_b(serverWorld, e));
    }

    private void func_218218_d(ServerWorld serverWorld, E e) {
        long l = serverWorld.func_82737_E();
        this.field_218232_c.values().stream().flatMap(map -> map.entrySet().stream()).filter(entry -> this.field_218236_g.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).filter(task -> task.func_220376_b() == Task.Status.STOPPED).forEach(task -> task.func_220378_b(serverWorld, e, l));
    }

    private void func_218222_e(ServerWorld serverWorld, E e) {
        long l = serverWorld.func_82737_E();
        this.func_218193_d().forEach(task -> task.func_220377_c(serverWorld, e, l));
    }

    private boolean func_218217_d(Activity activity) {
        return this.field_218234_e.get(activity).stream().allMatch(pair -> {
            MemoryModuleType memoryModuleType = (MemoryModuleType)pair.getFirst();
            MemoryModuleStatus \u26032 = (MemoryModuleStatus)((Object)((Object)pair.getSecond()));
            return this.func_218196_a(memoryModuleType, \u26032);
        });
    }

    private boolean func_218213_a(Object object) {
        return object instanceof Collection && ((Collection)object).isEmpty();
    }
}

