/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;

public abstract class DamageIndicatedItemFluidContainer
extends ItemFluidContainer
implements IInformationProvider {
    protected DamageIndicatedItemComponent component;
    protected Fluid fluid;

    public DamageIndicatedItemFluidContainer(Item.Properties builder, int capacity, Fluid fluid) {
        super(builder, capacity);
        this.fluid = fluid;
        this.init();
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> items) {
        if (this.func_194125_a(this.field_77701_a)) {
            this.component.fillItemGroup(itemGroup, items, this.fluid);
        }
    }

    @Override
    public ITextComponent getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        this.component.addInformation(itemStack, world, list, flag);
        super.func_77624_a(itemStack, world, list, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, 1.0f - (float)this.component.getDurability(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        IFluidHandler fluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack simulatedDrain = fluidHandler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        return simulatedDrain != null && simulatedDrain.getAmount() == amount;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new FluidHandlerItemCapacity(stack, this.capacity, this.getFluid());
    }
}

