/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TitaniumLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public TitaniumLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    public void createSimple(Block block) {
        this.lootTables.put(block, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name(block.getRegistryName().func_110623_a()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block))));
    }

    public void createEmpty(Block block) {
        this.lootTables.put(block, LootTable.func_216119_b());
    }

    public void func_200398_a(DirectoryCache cache) {
        this.add();
        this.lootTables.forEach((block, builder) -> this.write(cache, block.getRegistryName(), builder.func_216039_a(LootParameterSets.field_216267_h).func_216038_b()));
    }

    private void write(DirectoryCache cache, ResourceLocation resourceLocation, LootTable table) {
        Path output = this.generator.func_200391_b().resolve("data/" + resourceLocation.func_110624_b() + "/loot_tables/blocks/" + resourceLocation.func_110623_a() + ".json");
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)output);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't write loot table {}", (Object)output, (Object)e);
        }
    }

    public String func_200397_b() {
        return "Titanium Loot Table";
    }

    public abstract void add();
}

