/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public class UpdateClientMessage {
    private BlockPos spawnPos;
    private int range;
    private boolean dateAroundHalloween;
    private boolean isContributor;

    public UpdateClientMessage(BlockPos spawnPos, int range, boolean dateAroundHalloween, boolean isContributor) {
        this.spawnPos = spawnPos;
        this.range = range;
        this.dateAroundHalloween = dateAroundHalloween;
        this.isContributor = isContributor;
    }

    static UpdateClientMessage fromBytes(PacketBuffer buf) {
        return new UpdateClientMessage(BlockPos.func_218283_e((long)buf.readLong()), buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateClientMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.spawnPos.func_218275_a());
        buf.writeInt(msg.range);
        buf.writeBoolean(msg.dateAroundHalloween);
        buf.writeBoolean(msg.isContributor);
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                    Helper.isHalloween = message.dateAroundHalloween;
                    Helper.isContributor = message.isContributor;
                    PacketHandler.sendToServer(new UpdateServerMessage((GraveModel)((Object)((Object)ConfigTombstone.client.favoriteGrave.get())), (BlockGraveMarble.MarbleType)((Object)((Object)ConfigTombstone.client.favoriteGraveMarble.get())), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get(), (Boolean)ConfigTombstone.client.activateGraveBySneaking.get(), true));
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

