/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.SpawnHelper;

public class InOpenWaterCondition
implements ILootCondition {
    private static final ResourceLocation RL = new ResourceLocation("tombstone", "in_open_water");
    private static final InOpenWaterCondition INSTANCE = new InOpenWaterCondition();
    public static final Serializer SERIALIZER = new Serializer();

    private InOpenWaterCondition() {
    }

    public boolean test(LootContext context) {
        if (!((Boolean)ConfigTombstone.general.fishingTreasureInOpenWater.get()).booleanValue()) {
            return true;
        }
        Entity hook = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        return hook != null && this.isOpenWaterAround(hook.field_70170_p, hook.func_180425_c());
    }

    private boolean isOpenWater(World world, BlockPos pos, boolean inStillWater) {
        BlockState state = world.func_180495_p(pos);
        IFluidState fluidState = state.func_204520_s();
        if (inStillWater) {
            return fluidState.func_206884_a(FluidTags.field_206959_a) && fluidState.func_206889_d() && state.func_177230_c() != Blocks.field_203203_C && state.func_196952_d((IBlockReader)world, pos).func_197766_b();
        }
        return state.isAir((IBlockReader)world, pos) || state.func_177230_c() == Blocks.field_196651_dG || state.func_196952_d((IBlockReader)world, pos).func_197766_b();
    }

    private boolean isOpenWaterAround(World world, BlockPos pos) {
        int inStillWater = pos.func_177956_o();
        return SpawnHelper.getAllInBox(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(2, 1, 2)).allMatch(aPos -> this.isOpenWater(world, (BlockPos)aPos, aPos.func_177956_o() <= inStillWater));
    }

    public static ILootCondition.IBuilder builder() {
        return () -> INSTANCE;
    }

    private static class Serializer
    extends ILootCondition.AbstractSerializer<InOpenWaterCondition> {
        private Serializer() {
            super(RL, InOpenWaterCondition.class);
        }

        public void serialize(JsonObject json, InOpenWaterCondition value, JsonSerializationContext context) {
        }

        public InOpenWaterCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

