/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class BlockGrave
extends BlockGraveBase<TileEntityGrave> {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    @Override
    protected TileEntityGrave createTileGrave(BlockState state, IBlockReader world) {
        return new TileEntityGrave();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.func_201670_d()) {
            return this.activatePlayerGrave(world, pos, state, (ServerPlayerEntity)player) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean isToolEffective(BlockState state, ToolType type) {
        return false;
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, BlockState state, ServerPlayerEntity player) {
        boolean valid;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityGrave tile = (TileEntityGrave)((Object)this.getTileEntity(world, pos));
        if (tile == null || tile.countTicks < 30 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((PlayerEntity)player, new Location(pos, (IWorld)world));
        boolean bl = valid = hasKey || tile.isOwner((PlayerEntity)player) || !tile.getNeedAccess();
        if (valid) {
            tile.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.general.chanceMobOnGraveRecovery.get() > 0 && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> this.spawnRandomMob((ServerWorld)world, pos));
            }
        } else if (tile.canPlunder(player)) {
            if (!tile.isAbandoned(player)) {
                player.func_145747_a(LangKey.MESSAGE_TOMB_RAIDER_NOT_ABANDONED.getTranslation(new Object[0]));
            } else if (tile.wasPlunderedBy(player)) {
                player.func_145747_a(LangKey.MESSAGE_TOMB_RAIDER_VISITED.getTranslation(new Object[0]));
            } else {
                if (tile.plunder(player)) {
                    player.func_145747_a(LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.getTranslation(new Object[0]));
                    return true;
                }
                player.func_145747_a(LangKey.MESSAGE_TOMB_RAIDER_FAILED.getTranslation(new Object[0]));
            }
        } else if (ModItems.grave_key.countKeyInInventory((PlayerEntity)player) > 0) {
            player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_WRONG_KEY.getTranslation(new Object[0]));
        } else {
            player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.getTranslation(new Object[0]));
        }
        return valid;
    }

    private void spawnRandomMob(ServerWorld world, BlockPos pos) {
        ZombieEntity mob;
        Location spawnPos = new SpawnHelper(world, new BlockPos(pos.func_177958_n() + Helper.getRandom(-9, 9), pos.func_177956_o(), pos.func_177952_p() + Helper.getRandom(-9, 9))).findSafePlace(2, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        try {
            mob = (ZombieEntity)EntityType.field_200725_aD.func_200721_a((World)world);
            if (mob == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        mob.func_82227_f(true);
        if (Helper.isDateAroundHalloween()) {
            mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Blocks.field_150423_aK));
        }
        mob.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos((Entity)mob)), SpawnReason.TRIGGERED, null, null);
        mob.func_70012_b((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)mob);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity.func_225608_bj_() && entity.func_70089_S() && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity) && DeathHandler.INSTANCE.getOptionActivateGraveBySneaking(entity.func_110124_au())) {
            this.activatePlayerGrave(world, pos, state, (ServerPlayerEntity)entity);
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    private static Block.Properties getBuilder() {
        return Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 1.8E7f).func_200951_a(6).func_200947_a(SoundType.field_185851_d);
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName.func_110624_b(), "decorative_" + registryName.func_110623_a()))) != null && item != Items.field_190931_a) {
            return new ItemStack((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }
}

