/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.api.network.IFluxTransfer;
import sonar.fluxnetworks.common.connection.transfer.ConnectionTransfer;
import sonar.fluxnetworks.common.handler.TileEntityHandler;

public class SidedTransfers {
    protected final TileEntity host;
    protected Map<Direction, IFluxTransfer> transfers;

    public SidedTransfers(TileEntity host) {
        this.host = host;
        this.transfers = new HashMap<Direction, IFluxTransfer>();
        for (Direction facing : Direction.values()) {
            this.transfers.put(facing, null);
        }
    }

    public List<IFluxTransfer> getTransfers() {
        return Lists.newArrayList(this.transfers.values());
    }

    public IFluxTransfer getTransfer(Direction dir) {
        return this.transfers.get(dir);
    }

    public void updateTransfers(Direction ... faces) {
        for (Direction dir : faces) {
            ITileEnergyHandler handler;
            TileEntity tile = this.host.func_145831_w().func_175625_s(this.host.func_174877_v().func_177972_a(dir));
            IFluxTransfer transfer = this.transfers.get(dir);
            if (tile == null || (handler = TileEntityHandler.getEnergyHandler(tile, dir.func_176734_d())) == null) {
                this.transfers.put(dir, null);
                continue;
            }
            if (transfer == null || transfer.getTile() != tile) {
                this.transfers.put(dir, new ConnectionTransfer(handler, tile, dir));
                continue;
            }
            if (!transfer.isInvalid()) continue;
            this.transfers.put(dir, null);
        }
    }
}

