/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.FluxCacheTypes;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.utils.Capabilities;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkBase;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.connection.PriorityGroup;
import sonar.fluxnetworks.common.connection.TransferIterator;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.event.FluxConnectionEvent;

public class FluxNetworkServer
extends FluxNetworkBase {
    public HashMap<FluxCacheTypes, List<IFluxConnector>> connections = new HashMap();
    public Queue<IFluxConnector> toAdd = new ConcurrentLinkedQueue<IFluxConnector>();
    public Queue<IFluxConnector> toRemove = new ConcurrentLinkedQueue<IFluxConnector>();
    public boolean sortConnections = true;
    public List<PriorityGroup<IFluxPlug>> sortedPlugs = new ArrayList<PriorityGroup<IFluxPlug>>();
    public List<PriorityGroup<IFluxPoint>> sortedPoints = new ArrayList<PriorityGroup<IFluxPoint>>();
    private TransferIterator<IFluxPlug> plugTransferIterator = new TransferIterator();
    private TransferIterator<IFluxPoint> pointTransferIterator = new TransferIterator();
    public long bufferLimiter = 0L;

    public FluxNetworkServer() {
    }

    public FluxNetworkServer(int id, String name, EnumSecurityType security, int color, UUID owner, EnergyType energy, String password) {
        super(id, name, security, color, owner, energy, password);
    }

    public void addConnections() {
        if (this.toAdd.isEmpty()) {
            return;
        }
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            IFluxConnector flux = (IFluxConnector)iterator.next();
            FluxCacheTypes.getValidTypes(flux).forEach(t -> FluxUtils.addWithCheck(this.getConnections((FluxCacheTypes)t), flux));
            MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Connected(flux, this));
            iterator.remove();
            this.sortConnections = true;
        }
    }

    public void removeConnections() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        Iterator iterator = this.toRemove.iterator();
        while (iterator.hasNext()) {
            IFluxConnector flux = (IFluxConnector)iterator.next();
            FluxCacheTypes.getValidTypes(flux).forEach(t -> this.getConnections((FluxCacheTypes)t).removeIf(f -> f == flux));
            iterator.remove();
            this.sortConnections = true;
        }
    }

    @Override
    public <T extends IFluxConnector> List<T> getConnections(FluxCacheTypes<T> type) {
        return this.connections.computeIfAbsent(type, m -> new ArrayList());
    }

    @Override
    public void onEndServerTick() {
        ((NetworkStatistics)this.network_stats.getValue()).onStartServerTick();
        ((NetworkStatistics)this.network_stats.getValue()).startProfiling();
        this.addConnections();
        this.removeConnections();
        if (this.sortConnections) {
            this.sortConnections();
            this.sortConnections = false;
        }
        this.bufferLimiter = 0L;
        List<IFluxConnector> fluxConnectors = this.getConnections(FluxCacheTypes.flux);
        fluxConnectors.forEach(f -> {
            f.getTransferHandler().onStartCycle();
            this.bufferLimiter += f.getTransferHandler().getRequest();
        });
        if (!this.sortedPoints.isEmpty() && this.bufferLimiter > 0L && !this.sortedPlugs.isEmpty()) {
            this.pointTransferIterator.reset(this.sortedPoints, true);
            this.plugTransferIterator.reset(this.sortedPlugs, false);
            block0: while (this.pointTransferIterator.hasNext()) {
                while (this.plugTransferIterator.hasNext()) {
                    IFluxPlug plug = this.plugTransferIterator.getCurrentFlux();
                    IFluxPoint point = this.pointTransferIterator.getCurrentFlux();
                    if (plug.getConnectionType() == point.getConnectionType()) break block0;
                    long operate = plug.getTransferHandler().removeEnergyFromBuffer(point.getTransferHandler().getRequest(), true);
                    long removed = point.getTransferHandler().addEnergyToBuffer(operate, false);
                    if (removed > 0L) {
                        plug.getTransferHandler().removeEnergyFromBuffer(removed, false);
                        if (point.getTransferHandler().getRequest() > 0L) continue;
                        continue block0;
                    }
                    if (plug.getTransferHandler().getBuffer() < 4L) {
                        this.plugTransferIterator.incrementFlux();
                        continue;
                    }
                    this.pointTransferIterator.incrementFlux();
                    continue block0;
                }
                break block0;
            }
        }
        fluxConnectors.forEach(fluxConnector -> fluxConnector.getTransferHandler().onEndCycle());
        ((NetworkStatistics)this.network_stats.getValue()).stopProfiling();
        ((NetworkStatistics)this.network_stats.getValue()).onEndServerTick();
    }

    @Override
    public EnumAccessType getMemberPermission(PlayerEntity player) {
        ISuperAdmin sa;
        if (FluxConfig.enableSuperAdmin && (sa = (ISuperAdmin)player.getCapability(Capabilities.SUPER_ADMIN, null).orElse(null)) != null && sa.getPermission()) {
            return EnumAccessType.SUPER_ADMIN;
        }
        return ((List)this.network_players.getValue()).stream().collect(Collectors.toMap(NetworkMember::getPlayerUUID, NetworkMember::getAccessPermission)).getOrDefault(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()), ((EnumSecurityType)((Object)this.network_security.getValue())).isEncrypted() ? EnumAccessType.NONE : EnumAccessType.USER);
    }

    @Override
    public void onRemoved() {
        this.getConnections(FluxCacheTypes.flux).forEach(flux -> MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Disconnected((IFluxConnector)flux, this)));
        this.connections.clear();
        this.toAdd.clear();
        this.toRemove.clear();
        this.sortedPoints.clear();
        this.sortedPlugs.clear();
    }

    @Override
    public void queueConnectionAddition(IFluxConnector flux) {
        this.toAdd.add(flux);
        this.toRemove.remove(flux);
        this.addToLite(flux);
    }

    @Override
    public void queueConnectionRemoval(IFluxConnector flux, boolean chunkUnload) {
        this.toRemove.add(flux);
        this.toAdd.remove(flux);
        if (chunkUnload) {
            this.changeChunkLoaded(flux, false);
        } else {
            this.removeFromLite(flux);
        }
    }

    private void addToLite(IFluxConnector flux) {
        Optional<IFluxConnector> c = ((List)this.all_connectors.getValue()).stream().filter(f -> f.getCoords().equals(flux.getCoords())).findFirst();
        if (c.isPresent()) {
            this.changeChunkLoaded(flux, true);
        } else {
            FluxLiteConnector lite = new FluxLiteConnector(flux);
            ((List)this.all_connectors.getValue()).add(lite);
        }
    }

    private void removeFromLite(IFluxConnector flux) {
        ((List)this.all_connectors.getValue()).removeIf(f -> f.getCoords().equals(flux.getCoords()));
    }

    private void changeChunkLoaded(IFluxConnector flux, boolean chunkLoaded) {
        Optional<IFluxConnector> c = ((List)this.all_connectors.getValue()).stream().filter(f -> f.getCoords().equals(flux.getCoords())).findFirst();
        c.ifPresent(fluxConnector -> fluxConnector.setChunkLoaded(chunkLoaded));
    }

    @Override
    public void addNewMember(String name) {
        NetworkMember a = NetworkMember.createMemberByUsername(name);
        if (((List)this.network_players.getValue()).stream().noneMatch(f -> f.getPlayerUUID().equals(a.getPlayerUUID()))) {
            ((List)this.network_players.getValue()).add(a);
        }
    }

    @Override
    public void removeMember(UUID uuid) {
        ((List)this.network_players.getValue()).removeIf(p -> p.getPlayerUUID().equals(uuid) && !p.getAccessPermission().canDelete());
    }

    @Override
    public Optional<NetworkMember> getValidMember(UUID player) {
        return ((List)this.network_players.getValue()).stream().filter(f -> f.getPlayerUUID().equals(player)).findFirst();
    }

    public void markLiteSettingChanged(IFluxConnector flux) {
    }

    private void sortConnections() {
        this.sortedPlugs.clear();
        this.sortedPoints.clear();
        List<IFluxPlug> plugs = this.getConnections(FluxCacheTypes.plug);
        List<IFluxPoint> points = this.getConnections(FluxCacheTypes.point);
        plugs.forEach(p -> PriorityGroup.getOrCreateGroup(p.getPriority(), this.sortedPlugs).getConnectors().add(p));
        points.forEach(p -> PriorityGroup.getOrCreateGroup(p.getPriority(), this.sortedPoints).getConnectors().add(p));
        this.sortedPlugs.sort(Comparator.comparing(p -> -p.getPriority()));
        this.sortedPoints.sort(Comparator.comparing(p -> -p.getPriority()));
    }
}

