/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import sonar.fluxnetworks.FluxNetworks;

public class FluxConfig {
    public static final ClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean enableButtonSound;
    public static boolean enableOneProbeBasicInfo;
    public static boolean enableOneProbeAdvancedInfo;
    public static boolean enableOneProbeSneaking;
    public static boolean enableFluxRecipe;
    public static boolean enableOldRecipe;
    public static boolean enableChunkLoading;
    public static boolean enableSuperAdmin;
    public static int defaultLimit;
    public static int basicCapacity;
    public static int basicTransfer;
    public static int herculeanCapacity;
    public static int herculeanTransfer;
    public static int gargantuanCapacity;
    public static int gargantuanTransfer;
    public static int maximumPerPlayer;
    public static int superAdminRequiredPermission;
    public static List<String> blockBlacklistStrings;
    public static List<String> itemBlackListStrings;
    public static boolean enableGuiDebug;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        FluxConfig.reloadConfig((ModConfig.ModConfigEvent)configEvent);
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        FluxConfig.reloadConfig((ModConfig.ModConfigEvent)configEvent);
    }

    public static void reloadConfig(ModConfig.ModConfigEvent configEvent) {
        FluxNetworks.LOGGER.info("LOADING CONFIG");
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            FluxConfig.bakeCommonConfig();
            FluxConfig.verifyAndReadBlacklist();
            FluxConfig.generateFluxChunkConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            FluxConfig.bakeClientConfig();
        }
        FluxNetworks.LOGGER.info("LOADED CONFIG");
    }

    public static void bakeCommonConfig() {
        defaultLimit = (Integer)FluxConfig.COMMON_CONFIG.defaultLimit.get();
        basicCapacity = (Integer)FluxConfig.COMMON_CONFIG.basicCapacity.get();
        basicTransfer = (Integer)FluxConfig.COMMON_CONFIG.basicTransfer.get();
        herculeanCapacity = (Integer)FluxConfig.COMMON_CONFIG.herculeanCapacity.get();
        herculeanTransfer = (Integer)FluxConfig.COMMON_CONFIG.herculeanTransfer.get();
        gargantuanCapacity = (Integer)FluxConfig.COMMON_CONFIG.gargantuanCapacity.get();
        gargantuanTransfer = (Integer)FluxConfig.COMMON_CONFIG.gargantuanTransfer.get();
        maximumPerPlayer = (Integer)FluxConfig.COMMON_CONFIG.maximumPerPlayer.get();
        superAdminRequiredPermission = (Integer)FluxConfig.COMMON_CONFIG.superAdminRequiredPermission.get();
        enableSuperAdmin = (Boolean)FluxConfig.COMMON_CONFIG.enableSuperAdmin.get();
        enableFluxRecipe = (Boolean)FluxConfig.COMMON_CONFIG.enableFluxRecipe.get();
        enableOldRecipe = (Boolean)FluxConfig.COMMON_CONFIG.enableOldRecipe.get();
        enableChunkLoading = (Boolean)FluxConfig.COMMON_CONFIG.enableChunkLoading.get();
        blockBlacklistStrings = (List)FluxConfig.COMMON_CONFIG.blockBlacklistStrings.get();
        itemBlackListStrings = (List)FluxConfig.COMMON_CONFIG.itemBlackListStrings.get();
    }

    public static void bakeClientConfig() {
        enableButtonSound = (Boolean)FluxConfig.CLIENT_CONFIG.enableButtonSound.get();
        enableOneProbeBasicInfo = (Boolean)FluxConfig.CLIENT_CONFIG.enableOneProbeBasicInfo.get();
        enableOneProbeAdvancedInfo = (Boolean)FluxConfig.CLIENT_CONFIG.enableOneProbeAdvancedInfo.get();
        enableOneProbeSneaking = (Boolean)FluxConfig.CLIENT_CONFIG.enableOneProbeSneaking.get();
        enableGuiDebug = (Boolean)FluxConfig.CLIENT_CONFIG.enableGuiDebug.get();
    }

    public static void verifyAndReadBlacklist() {
    }

    public static void generateFluxChunkConfig() {
    }

    static {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        COMMON_CONFIG = (CommonConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT_CONFIG = (ClientConfig)clientPair.getLeft();
    }

    public static class ClientConfig {
        public ForgeConfigSpec.BooleanValue enableButtonSound;
        public ForgeConfigSpec.BooleanValue enableOneProbeBasicInfo;
        public ForgeConfigSpec.BooleanValue enableOneProbeAdvancedInfo;
        public ForgeConfigSpec.BooleanValue enableOneProbeSneaking;
        public ForgeConfigSpec.BooleanValue enableGuiDebug;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.enableButtonSound = builder.comment("Enable navigation buttons sound when pressing it").translation("fluxnetworks.config.enableButtonSound").define("enableButtonSound", true);
            this.enableGuiDebug = builder.comment("Internal use only! Keep this to false!").define("enableGuiDebug", false);
            builder.pop();
            builder.push("OneProbe");
            this.enableOneProbeBasicInfo = builder.comment("Displays: Network Name, Live Transfer Rate & Internal Buffer").translation("fluxnetworks.config.enableOneProbeBasicInfo").define("enableOneProbeBasicInfo", true);
            this.enableOneProbeAdvancedInfo = builder.comment("Displays: Transfer Limit & Priority etc").translation("fluxnetworks.config.enableOneProbeAdvancedInfo").define("enableOneProbeAdvancedInfo", true);
            this.enableOneProbeSneaking = builder.comment("Displays Advanced Info when sneaking only").translation("fluxnetworks.config.enableOneProbeSneaking").define("enableOneProbeSneaking", true);
            builder.pop();
        }
    }

    public static class CommonConfig {
        public ForgeConfigSpec.IntValue defaultLimit;
        public ForgeConfigSpec.IntValue basicCapacity;
        public ForgeConfigSpec.IntValue basicTransfer;
        public ForgeConfigSpec.IntValue herculeanCapacity;
        public ForgeConfigSpec.IntValue herculeanTransfer;
        public ForgeConfigSpec.IntValue gargantuanCapacity;
        public ForgeConfigSpec.IntValue gargantuanTransfer;
        public ForgeConfigSpec.IntValue maximumPerPlayer;
        public ForgeConfigSpec.IntValue superAdminRequiredPermission;
        public ForgeConfigSpec.BooleanValue enableSuperAdmin;
        public ForgeConfigSpec.BooleanValue enableFluxRecipe;
        public ForgeConfigSpec.BooleanValue enableOldRecipe;
        public ForgeConfigSpec.BooleanValue enableChunkLoading;
        public ForgeConfigSpec.ConfigValue<List<String>> blockBlacklistStrings;
        public ForgeConfigSpec.ConfigValue<List<String>> itemBlackListStrings;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("energy");
            this.defaultLimit = builder.comment("The default transfer limit of a flux connector").translation("fluxnetworks.config.defaultLimit").defineInRange("defaultLimit", 800000, 0, Integer.MAX_VALUE);
            this.basicCapacity = builder.translation("fluxnetworks.config.basicCapacity").defineInRange("basicCapacity", 1000000, 0, Integer.MAX_VALUE);
            this.basicTransfer = builder.translation("fluxnetworks.config.basicTransfer").defineInRange("basicTransfer", 20000, 0, Integer.MAX_VALUE);
            this.herculeanCapacity = builder.translation("fluxnetworks.config.herculeanCapacity").defineInRange("herculeanCapacity", 8000000, 0, Integer.MAX_VALUE);
            this.herculeanTransfer = builder.translation("fluxnetworks.config.herculeanTransfer").defineInRange("herculeanTransfer", 120000, 0, Integer.MAX_VALUE);
            this.gargantuanCapacity = builder.translation("fluxnetworks.config.gargantuanCapacity").defineInRange("gargantuanCapacity", 128000000, 0, Integer.MAX_VALUE);
            this.gargantuanTransfer = builder.translation("fluxnetworks.config.gargantuanTransfer").defineInRange("gargantuanTransfer", 1440000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("networks");
            this.maximumPerPlayer = builder.comment("Maximum networks each player can have. -1 = no limit").translation("fluxnetworks.config.maximumPerPlayer").defineInRange("maximumPerPlayer", 5, -1, Integer.MAX_VALUE);
            this.enableSuperAdmin = builder.comment("Allows someone to be a network super admin, otherwise, no one can access or dismantle your flux devices or delete your networks without permission").translation("fluxnetworks.config.enableSuperAdmin").define("enableSuperAdmin", true);
            this.superAdminRequiredPermission = builder.comment("See ops.json. If the player has permission level equal or greater to the value set here they will be able to Activate Super Admin. Setting this to 0 will allow anyone to active Super Admin.").translation("fluxnetworks.config.superAdminRequiredPermission").defineInRange("superAdminRequiredPermission", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("general");
            this.enableFluxRecipe = builder.comment("Enables redstones being compressed with the bedrock and obsidian to get flux").translation("fluxnetworks.config.enableFluxRecipe").define("enableFluxRecipe", true);
            this.enableOldRecipe = builder.comment("Enables redstone being turned into Flux when dropped in fire. (Need \"Enable Flux Recipe\" = true, so the default recipe can't be disabled if turns this on)").translation("fluxnetworks.config.enableOldRecipe").define("enableOldRecipe", false);
            this.enableChunkLoading = builder.comment("Allows flux tiles to work as chunk loaders").translation("fluxnetworks.config.enableChunkLoading").define("enableChunkLoading", true);
            builder.pop();
            builder.push("blacklist");
            this.blockBlacklistStrings = builder.comment("a blacklist for blocks which flux connections shouldn't connect to, use format 'modid:name@blockstate'").translation("fluxnetworks.config.blockBlacklistStrings").define("blockBlacklistStrings", (Object)Lists.newArrayList((Object[])new String[]{"actuallyadditions:block_phantom_energyface"}));
            this.itemBlackListStrings = builder.comment("a blacklist for items which the Flux Controller shouldn't transfer to, use format 'modid:name@blockstate'").translation("fluxnetworks.config.itemBlackListStrings").define("itemBlackListStrings", (Object)Lists.newArrayList((Object[])new String[]{""}));
            builder.pop();
        }
    }
}

