/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client;

import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.google.common.base.Stopwatch;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Iron Jetpacks");

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("ironjetpacks", "item/cell"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("ironjetpacks", "item/capacitor"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("ironjetpacks", "item/thruster"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("ironjetpacks", "item/jetpack"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModelRegistry();
        IBakedModel cell = (IBakedModel)registry.get(new ResourceLocation("ironjetpacks", "item/cell"));
        IBakedModel capacitor = (IBakedModel)registry.get(new ResourceLocation("ironjetpacks", "item/capacitor"));
        IBakedModel thruster = (IBakedModel)registry.get(new ResourceLocation("ironjetpacks", "item/thruster"));
        IBakedModel jetpack = (IBakedModel)registry.get(new ResourceLocation("ironjetpacks", "item/jetpack"));
        JetpackRegistry.getInstance().getAllJetpacks().forEach(pack -> {
            ResourceLocation jetpackLocation;
            ResourceLocation thrusterLocation;
            ResourceLocation capacitorLocation;
            ResourceLocation cellLocation = pack.cell.getRegistryName();
            if (cellLocation != null) {
                ModelResourceLocation location = new ModelResourceLocation(cellLocation, "inventory");
                registry.replace(location, cell);
            }
            if ((capacitorLocation = pack.capacitor.getRegistryName()) != null) {
                ModelResourceLocation location = new ModelResourceLocation(capacitorLocation, "inventory");
                registry.replace(location, capacitor);
            }
            if ((thrusterLocation = pack.thruster.getRegistryName()) != null) {
                ModelResourceLocation location = new ModelResourceLocation(thrusterLocation, "inventory");
                registry.replace(location, thruster);
            }
            if ((jetpackLocation = pack.item.getRegistryName()) != null) {
                ModelResourceLocation location = new ModelResourceLocation(jetpackLocation, "inventory");
                registry.replace(location, jetpack);
            }
        });
        LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }
}

