/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.RadialChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.logistics.block.belts.observer.BeltObserverBlock;
import com.simibubi.create.content.palettes.PavedBlock;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.worldgen.OxidizingBlock;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class BlockStateGen {
    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> axisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.axisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalBlockProvider(boolean customItem) {
        return (c, p) -> p.directionalBlock((Block)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalBlockProvider(boolean customItem) {
        return (c, p) -> p.horizontalBlock((Block)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalAxisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalAxisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends DirectionalAxisKineticBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalAxisBlockProvider() {
        return (c, p) -> BlockStateGen.directionalAxisBlock(c, p, ($, vertical) -> p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/" + (vertical != false ? "vertical" : "horizontal"))));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalWheelProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalWheel(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <P> NonNullUnaryOperator<BlockBuilder<OxidizingBlock, P>> oxidizedBlockstate() {
        return b -> b.blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            String name = AssetLookup.getOxidizedModel(ctx.getName(), (Integer)state.func_177229_b((IProperty)OxidizingBlock.OXIDIZATION));
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeAll(name, prov.modLoc(name))).build();
        }));
    }

    private static <T extends Block> Function<BlockState, ModelFile> getBlockModel(boolean customItem, DataGenContext<Block, T> c, RegistrateBlockstateProvider p) {
        return $ -> customItem ? AssetLookup.partialBaseModel(c, p, new String[0]) : AssetLookup.standardModel(c, p);
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 180 : 0)).build();
        });
    }

    public static <T extends Block> void horizontalAxisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        });
    }

    public static <T extends DirectionalAxisKineticBlock> void directionalAxisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BiFunction<BlockState, Boolean, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int xRot;
            boolean vertical;
            boolean alongFirst = (Boolean)state.func_177229_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            Direction direction = (Direction)state.func_177229_b((IProperty)DirectionalAxisKineticBlock.FACING);
            boolean bl = direction.func_176740_k().func_176722_c() && direction.func_176740_k() == Direction.Axis.X == alongFirst ? true : (vertical = false);
            int n = direction == Direction.DOWN ? 270 : (xRot = direction == Direction.UP ? 90 : 0);
            int yRot = direction.func_176740_k().func_200128_b() ? (alongFirst ? 0 : 90) : (int)direction.func_185119_l();
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state, vertical)).rotationX(xRot).rotationY(yRot).build();
        });
    }

    public static <T extends Block> void horizontalWheel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(90).rotationY(((int)((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build());
    }

    public static <T extends Block> void cubeAll(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir) {
        BlockStateGen.cubeAll(ctx, prov, textureSubDir, ctx.getName());
    }

    public static <T extends Block> void cubeAll(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir, String name) {
        String texturePath = "block/" + textureSubDir + name;
        prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc(texturePath)));
    }

    public static <T extends Block> void pavedBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, ModelFile top, ModelFile covered) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((IProperty)PavedBlock.COVERED) != false ? covered : top).build());
    }

    public static NonNullBiConsumer<DataGenContext<Block, CartAssemblerBlock>, RegistrateBlockstateProvider> cartAssembler() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block" + ((Boolean)state.func_177229_b((IProperty)CartAssemblerBlock.POWERED) != false ? "_powered" : "")))).rotationY(state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE) == RailShape.EAST_WEST ? 90 : 0).build());
    }

    public static NonNullBiConsumer<DataGenContext<Block, BeltObserverBlock>, RegistrateBlockstateProvider> beltObserver() {
        return (c, p) -> {
            IdentityHashMap models = new IdentityHashMap();
            HashMap<String, ResourceLocation> baseModels = new HashMap<String, ResourceLocation>();
            for (boolean powered : Iterate.trueAndFalse) {
                for (boolean belt : Iterate.trueAndFalse) {
                    String suffix = (belt ? "_belt" : "") + (powered ? "_powered" : "");
                    baseModels.put(suffix, p.modLoc("block/belt_observer/base" + suffix));
                }
            }
            for (BeltObserverBlock.Mode mode : BeltObserverBlock.Mode.values()) {
                String modeName = mode.func_176610_l();
                HashMap<String, ModelBuilder> map = new HashMap<String, ModelBuilder>();
                for (boolean powered : Iterate.trueAndFalse) {
                    for (boolean belt : Iterate.trueAndFalse) {
                        String suffix = (belt ? "_belt" : "") + (powered ? "_powered" : "");
                        map.put(suffix, ((BlockModelBuilder)p.models().withExistingParent("block/belt_observer/" + modeName + suffix, (ResourceLocation)baseModels.get(suffix))).texture("texture", p.modLoc("block/belt_observer_" + modeName + (powered ? "_powered" : ""))));
                    }
                }
                models.put(mode, map);
            }
            p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
                String suffix = ((Boolean)state.func_177229_b((IProperty)BeltObserverBlock.BELT) != false ? "_belt" : "") + ((Boolean)state.func_177229_b((IProperty)BeltObserverBlock.POWERED) != false ? "_powered" : "");
                return ConfiguredModel.builder().modelFile((ModelFile)((Map)models.get(state.func_177229_b(BeltObserverBlock.MODE))).get(suffix)).rotationY((int)((Direction)state.func_177229_b((IProperty)BeltObserverBlock.field_185512_D)).func_185119_l()).build();
            });
        };
    }

    public static <B extends LinearChassisBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> linearChassis() {
        return (c, p) -> {
            ResourceLocation side = p.modLoc("block/" + c.getName() + "_side");
            ResourceLocation top = p.modLoc("block/linear_chassis_end");
            ResourceLocation top_sticky = p.modLoc("block/linear_chassis_end_sticky");
            Vector<ModelBuilder> models = new Vector<ModelBuilder>(4);
            for (boolean isTopSticky : Iterate.trueAndFalse) {
                for (boolean isBottomSticky : Iterate.trueAndFalse) {
                    models.add(((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + (isTopSticky ? "_top" : "") + (isBottomSticky ? "_bottom" : ""), "block/cube_bottom_top")).texture("side", side)).texture("bottom", isBottomSticky ? top_sticky : top)).texture("top", isTopSticky ? top_sticky : top));
                }
            }
            BiFunction<Boolean, Boolean, ModelFile> modelFunc = (t, b) -> (ModelFile)models.get((t != false ? 0 : 2) + (b != false ? 0 : 1));
            BlockStateGen.axisBlock(c, p, state -> (ModelFile)modelFunc.apply((Boolean)state.func_177229_b((IProperty)LinearChassisBlock.STICKY_TOP), (Boolean)state.func_177229_b((IProperty)LinearChassisBlock.STICKY_BOTTOM)));
        };
    }

    public static <B extends RadialChassisBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> radialChassis() {
        return (c, p) -> {
            String suffix;
            String path = "block/" + c.getName();
            ResourceLocation side = p.modLoc(path + "_side");
            ResourceLocation side_sticky = p.modLoc(path + "_side_sticky");
            String templateModelPath = "block/radial_chassis";
            ModelFile.ExistingModelFile base = p.models().getExistingFile(p.modLoc(templateModelPath + "/base"));
            Vector<ModelBuilder> faces = new Vector<ModelBuilder>(3);
            Vector<ModelBuilder> stickyFaces = new Vector<ModelBuilder>(3);
            for (Direction.Axis axis : Iterate.axes) {
                suffix = "side_" + axis.func_176610_l();
                faces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix, p.modLoc(templateModelPath + "/" + suffix))).texture("side", side));
            }
            for (Direction.Axis axis : Iterate.axes) {
                suffix = "side_" + axis.func_176610_l();
                stickyFaces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix + "_sticky", p.modLoc(templateModelPath + "/" + suffix))).texture("side", side_sticky));
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            BlockState propertyGetter = (BlockState)((RadialChassisBlock)c.get()).func_176223_P().func_206870_a((IProperty)RadialChassisBlock.field_176298_M, (Comparable)Direction.Axis.Y);
            for (Direction.Axis axis : Iterate.axes) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationX(axis != Direction.Axis.Y ? 90 : 0).rotationY(axis != Direction.Axis.X ? 0 : 90).addModel()).condition((IProperty)RadialChassisBlock.field_176298_M, (Comparable[])new Direction.Axis[]{axis}).end();
            }
            for (Direction.Axis axis : Iterate.horizontalDirections) {
                for (boolean sticky : Iterate.trueAndFalse) {
                    for (Direction.Axis axis2 : Iterate.axes) {
                        int horizontalAngle = (int)axis.func_185119_l();
                        int index = axis2.ordinal();
                        int xRot = 0;
                        int yRot = 0;
                        if (axis2 == Direction.Axis.X) {
                            xRot = -horizontalAngle + 180;
                        }
                        if (axis2 == Direction.Axis.Y) {
                            yRot = horizontalAngle;
                        }
                        if (axis2 == Direction.Axis.Z) {
                            yRot = -horizontalAngle + 270;
                            if (axis.func_176740_k() == Direction.Axis.Z) {
                                index = 0;
                                xRot = horizontalAngle + 180;
                                yRot = 90;
                            }
                        }
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(sticky ? stickyFaces : faces).get(index)).rotationX((xRot + 360) % 360).rotationY((yRot + 360) % 360).addModel()).condition((IProperty)RadialChassisBlock.field_176298_M, (Comparable[])new Direction.Axis[]{axis2}).condition((IProperty)((RadialChassisBlock)c.get()).getGlueableSide(propertyGetter, (Direction)axis), (Comparable[])new Boolean[]{sticky}).end();
                    }
                }
            }
        };
    }
}

