/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.config.StressConfigDefaults;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CStress
extends ConfigBase {
    private Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    private Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    @Override
    protected void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"", Comments.su, Comments.impact}).push("impact");
        StressConfigDefaults.registeredDefaultImpacts.forEach((r, i) -> this.getImpacts().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.func_110623_a(), i)));
        builder.pop();
        builder.comment(new String[]{"", Comments.su, Comments.capacity}).push("capacity");
        StressConfigDefaults.registeredDefaultCapacities.forEach((r, i) -> this.getCapacities().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.func_110623_a(), i)));
        builder.pop();
    }

    public double getImpactOf(Block block) {
        ResourceLocation key = block.getRegistryName();
        return this.getImpacts().containsKey(key) ? (Double)this.getImpacts().get(key).get() : 0.0;
    }

    public double getCapacityOf(Block block) {
        ResourceLocation key = block.getRegistryName();
        return this.getCapacities().containsKey(key) ? (Double)this.getCapacities().get(key).get() : 0.0;
    }

    @Override
    public String getName() {
        return "stressValues.v1";
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getImpacts() {
        return this.impacts;
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getCapacities() {
        return this.capacities;
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        private Comments() {
        }
    }
}

