/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AttributeFilterScreen
extends AbstractFilterScreen<AttributeFilterContainer> {
    private static final String PREFIX = "gui.attribute_filter.";
    private IconButton whitelistDis;
    private IconButton whitelistCon;
    private IconButton blacklist;
    private Indicator whitelistDisIndicator;
    private Indicator whitelistConIndicator;
    private Indicator blacklistIndicator;
    private IconButton add;
    private String whitelistDisN = Lang.translate("gui.attribute_filter.whitelist_disjunctive", new Object[0]);
    private String whitelistDisDESC = Lang.translate("gui.attribute_filter.whitelist_disjunctive.description", new Object[0]);
    private String whitelistConN = Lang.translate("gui.attribute_filter.whitelist_conjunctive", new Object[0]);
    private String whitelistConDESC = Lang.translate("gui.attribute_filter.whitelist_conjunctive.description", new Object[0]);
    private String blacklistN = Lang.translate("gui.attribute_filter.blacklist", new Object[0]);
    private String blacklistDESC = Lang.translate("gui.attribute_filter.blacklist.description", new Object[0]);
    private String referenceH = Lang.translate("gui.attribute_filter.add_reference_item", new Object[0]);
    private String noSelectedT = Lang.translate("gui.attribute_filter.no_selected_attributes", new Object[0]);
    private String selectedT = Lang.translate("gui.attribute_filter.selected_attributes", new Object[0]);
    private ItemStack lastItemScanned = ItemStack.field_190927_a;
    private List<ItemAttribute> attributesOfItem = new ArrayList<ItemAttribute>();
    private List<String> selectedAttributes = new ArrayList<String>();
    private SelectionScrollInput attributeSelector;
    private Label attributeSelectorLabel;

    public AttributeFilterScreen(AttributeFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title, AllGuiTextures.ATTRIBUTE_FILTER);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.whitelistDis = new IconButton(x + 84, y + 58, AllIcons.I_WHITELIST_OR);
        this.whitelistDis.setToolTip(this.whitelistDisN);
        this.whitelistCon = new IconButton(x + 102, y + 58, AllIcons.I_WHITELIST_AND);
        this.whitelistCon.setToolTip(this.whitelistConN);
        this.blacklist = new IconButton(x + 120, y + 58, AllIcons.I_WHITELIST_NOT);
        this.blacklist.setToolTip(this.blacklistN);
        this.whitelistDisIndicator = new Indicator(x + 84, y + 53, "");
        this.whitelistConIndicator = new Indicator(x + 102, y + 53, "");
        this.blacklistIndicator = new Indicator(x + 120, y + 53, "");
        this.widgets.addAll(Arrays.asList(new AbstractSimiWidget[]{this.blacklist, this.whitelistCon, this.whitelistDis, this.blacklistIndicator, this.whitelistConIndicator, this.whitelistDisIndicator}));
        this.add = new IconButton(x + 159, y + 22, AllIcons.I_ADD);
        this.widgets.add(this.add);
        this.handleIndicators();
        this.attributeSelectorLabel = new Label(x + 40, y + 27, "").colored(15985630).withShadow();
        this.attributeSelector = new SelectionScrollInput(x + 37, y + 24, 118, 14);
        this.attributeSelector.forOptions(Arrays.asList(""));
        this.attributeSelector.calling(s -> {});
        this.referenceItemChanged(((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(0));
        this.widgets.add(this.attributeSelector);
        this.widgets.add(this.attributeSelectorLabel);
        this.selectedAttributes.clear();
        this.selectedAttributes.add(TextFormatting.YELLOW + (((AttributeFilterContainer)this.field_147002_h).selectedAttributes.isEmpty() ? this.noSelectedT : this.selectedT));
        ((AttributeFilterContainer)this.field_147002_h).selectedAttributes.forEach(at -> this.selectedAttributes.add(TextFormatting.GRAY + "- " + at.format()));
    }

    private void referenceItemChanged(ItemStack stack) {
        this.lastItemScanned = stack;
        if (stack.func_190926_b()) {
            this.attributeSelector.active = false;
            this.attributeSelector.visible = false;
            this.attributeSelectorLabel.text = TextFormatting.ITALIC + this.referenceH;
            this.add.active = false;
            this.attributeSelector.calling(s -> {});
            return;
        }
        this.add.active = true;
        this.attributeSelector.titled(stack.func_200301_q().func_150254_d() + "...");
        this.attributesOfItem.clear();
        for (ItemAttribute itemAttribute : ItemAttribute.types) {
            this.attributesOfItem.addAll(itemAttribute.listAttributesOf(stack, (World)this.minecraft.field_71441_e));
        }
        List<String> options = this.attributesOfItem.stream().map(ItemAttribute::format).collect(Collectors.toList());
        this.attributeSelector.forOptions(options);
        this.attributeSelector.active = true;
        this.attributeSelector.visible = true;
        this.attributeSelector.setState(0);
        this.attributeSelector.calling(i -> {
            this.attributeSelectorLabel.setTextAndTrim((String)options.get((int)i), true, 112);
            ItemAttribute selected = this.attributesOfItem.get((int)i);
            for (ItemAttribute existing : ((AttributeFilterContainer)this.field_147002_h).selectedAttributes) {
                CompoundNBT testTag = new CompoundNBT();
                CompoundNBT testTag2 = new CompoundNBT();
                existing.serializeNBT(testTag);
                selected.serializeNBT(testTag2);
                if (!testTag.equals((Object)testTag2)) continue;
                this.add.active = false;
                return;
            }
            this.add.active = true;
        });
        this.attributeSelector.onChanged();
    }

    @Override
    public void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = ((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(1);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.setBlitOffset(200);
        this.itemRenderer.field_77023_b = 200.0f;
        this.itemRenderer.func_180453_a(this.font, stack, this.field_147003_i + 59, this.field_147009_r + 56, String.valueOf(this.selectedAttributes.size() - 1));
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
        super.renderWindowForeground(mouseX, mouseY, partialTicks);
    }

    @Override
    public void tick() {
        super.tick();
        ItemStack stackInSlot = ((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(0);
        if (!stackInSlot.equals(this.lastItemScanned, false)) {
            this.referenceItemChanged(stackInSlot);
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_147006_u.field_75222_d == 37) {
                this.renderTooltip(this.selectedAttributes, mouseX, mouseY, this.font);
                return;
            }
            this.renderTooltip(this.field_147006_u.func_75211_c(), mouseX, mouseY);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(this.blacklist, this.whitelistCon, this.whitelistDis);
    }

    @Override
    protected List<String> getTooltipDescriptions() {
        return Arrays.asList(this.blacklistDESC, this.whitelistConDESC, this.whitelistDisDESC);
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        int index;
        boolean mouseClicked = super.mouseClicked(x, y, button);
        if (button != 0) {
            return mouseClicked;
        }
        if (this.blacklist.isHovered()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.BLACKLIST;
            this.sendOptionUpdate(FilterScreenPacket.Option.BLACKLIST);
            return true;
        }
        if (this.whitelistCon.isHovered()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST2);
            return true;
        }
        if (this.whitelistDis.isHovered()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST);
            return true;
        }
        if (this.add.isHovered() && this.add.active && (index = this.attributeSelector.getState()) < this.attributesOfItem.size()) {
            this.add.active = false;
            CompoundNBT tag = new CompoundNBT();
            ItemAttribute itemAttribute = this.attributesOfItem.get(index);
            itemAttribute.serializeNBT(tag);
            AllPackets.channel.sendToServer((Object)new FilterScreenPacket(FilterScreenPacket.Option.ADD_TAG, tag));
            ((AttributeFilterContainer)this.field_147002_h).selectedAttributes.add(itemAttribute);
            if (((AttributeFilterContainer)this.field_147002_h).selectedAttributes.size() == 1) {
                this.selectedAttributes.set(0, TextFormatting.YELLOW + this.selectedT);
            }
            this.selectedAttributes.add(TextFormatting.GRAY + "- " + itemAttribute.format());
            return true;
        }
        return mouseClicked;
    }

    @Override
    protected void contentsCleared() {
        this.selectedAttributes.clear();
        this.selectedAttributes.add(TextFormatting.YELLOW + this.noSelectedT);
        if (!this.lastItemScanned.func_190926_b()) {
            this.add.active = true;
        }
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        if (button == this.blacklist) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.BLACKLIST;
        }
        if (button == this.whitelistCon) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
        }
        if (button == this.whitelistDis) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
        }
        return true;
    }

    @Override
    protected boolean isIndicatorOn(Indicator indicator) {
        if (indicator == this.blacklistIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.BLACKLIST;
        }
        if (indicator == this.whitelistConIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
        }
        if (indicator == this.whitelistDisIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
        }
        return false;
    }
}

