/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.extractor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.content.logistics.block.extractor.ExtractorBlock;
import com.simibubi.create.content.logistics.block.extractor.ExtractorSlots;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.AutoExtractingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.ExtractingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.SingleTargetAutoExtractingBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class ExtractorTileEntity
extends SmartTileEntity {
    protected ExtractingBehaviour extracting;
    protected FilteringBehaviour filtering;
    protected boolean extractingToBelt;

    public ExtractorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        int delay = (Integer)AllConfigs.SERVER.logistics.extractorDelay.get();
        this.extracting = new SingleTargetAutoExtractingBehaviour((SmartTileEntity)this, () -> AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()), this::onExtract, delay).pauseWhen(this::isPowered).waitUntil(this::canExtract);
        behaviours.add(this.extracting);
        this.filtering = new FilteringBehaviour(this, new ExtractorSlots.Filter()).withCallback(this::filterChanged);
        this.filtering.showCount();
        behaviours.add(this.filtering);
    }

    protected void onExtract(ItemStack stack) {
        TileEntity te;
        if (AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof BeltTileEntity && ((BeltTileEntity)te).tryInsertingFromSide(Direction.UP, stack, false)) {
            return;
        }
        Vec3d entityPos = VecHelper.getCenterOf((Vec3i)this.func_174877_v()).func_72441_c(0.0, -0.5, 0.0);
        ItemEntity entityIn = null;
        Direction facing = AttachedLogisticalBlock.getBlockFacing(this.func_195044_w());
        if (facing == Direction.DOWN) {
            entityPos = entityPos.func_72441_c(0.0, 0.5, 0.0);
        }
        entityIn = new ItemEntity(this.field_145850_b, entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c, stack);
        entityIn.func_213317_d(Vec3d.field_186680_a);
        entityIn.func_174867_a(5);
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.125f, 0.1f);
        this.field_145850_b.func_217376_c((Entity)entityIn);
    }

    protected boolean isAttachedToBelt() {
        Direction blockFacing = AttachedLogisticalBlock.getBlockFacing(this.func_195044_w());
        return AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(blockFacing)));
    }

    protected boolean isTargetingBelt() {
        if (!AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te == null || !(te instanceof BeltTileEntity)) {
            return false;
        }
        return ((KineticTileEntity)te).getSpeed() != 0.0f;
    }

    protected boolean isPowered() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)ExtractorBlock.POWERED);
    }

    private void filterChanged(ItemStack stack) {
    }

    protected boolean canExtract() {
        if (AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (te instanceof BeltTileEntity) {
                BeltTileEntity belt = (BeltTileEntity)te;
                if (belt.getSpeed() == 0.0f) {
                    return false;
                }
                BeltTileEntity controller = belt.getControllerTE();
                if (controller != null) {
                    BeltInventory inventory = controller.getInventory();
                    if (inventory == null) {
                        return false;
                    }
                    if (!inventory.canInsertFrom(belt.index, Direction.UP)) {
                        return false;
                    }
                }
            }
            return true;
        }
        List entitiesWithinAABBExcludingEntity = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.func_174877_v()));
        return entitiesWithinAABBExcludingEntity.isEmpty();
    }

    @Override
    public void func_73660_a() {
        ((AutoExtractingBehaviour)this.extracting).setTicking(!this.isAttachedToBelt());
        super.func_73660_a();
        boolean onBelt = this.isTargetingBelt();
        if (this.extractingToBelt != onBelt) {
            this.extractingToBelt = onBelt;
            ((AutoExtractingBehaviour)this.extracting).setDelay(onBelt ? 0 : (Integer)AllConfigs.SERVER.logistics.extractorDelay.get());
        }
    }
}

