/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.extractor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.content.logistics.block.transposer.TransposerBlock;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;

public class ExtractorSlots {

    public static class Link
    extends ValueBoxTransform.Dual {
        Vec3d offsetForHorizontal = VecHelper.voxelSpace(11.5, 4.0, 14.0);
        Vec3d offsetForUpward = VecHelper.voxelSpace(10.0, 14.0, 11.5);
        Vec3d offsetForDownward = VecHelper.voxelSpace(10.0, 2.0, 11.5);

        public Link(boolean first) {
            super(first);
        }

        @Override
        protected Vec3d getLocalOffset(BlockState state) {
            Vec3d location = this.offsetForHorizontal;
            if (state.func_177230_c() instanceof TransposerBlock) {
                location = location.func_72441_c(0.0, 0.125, 0.0);
            }
            if (!this.isFirst()) {
                location = location.func_72441_c(0.0, 0.25, 0.0);
            }
            if (AttachedLogisticalBlock.isVertical(state)) {
                Vec3d vec3d = location = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? this.offsetForUpward : this.offsetForDownward;
                if (!this.isFirst()) {
                    location = location.func_72441_c(-0.25, 0.0, 0.0);
                }
            }
            float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            location = VecHelper.rotateCentered(location, yRot, Direction.Axis.Y);
            return location;
        }

        @Override
        protected void rotate(BlockState state, MatrixStack ms) {
            float yRot;
            float horizontalAngle = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            boolean vertical = AttachedLogisticalBlock.isVertical(state);
            float f = yRot = vertical ? horizontalAngle + 180.0f : horizontalAngle + 270.0f;
            float zRot = vertical ? (float)((Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? 90 : 270) : 0.0f;
            MatrixStacker.of(ms).rotateY(yRot).rotateZ(zRot);
        }
    }

    static class Filter
    extends ValueBoxTransform {
        Vec3d offsetForHorizontal = VecHelper.voxelSpace(8.0, 10.5, 14.0);
        Vec3d offsetForUpward = VecHelper.voxelSpace(8.0, 14.15f, 3.5);
        Vec3d offsetForDownward = VecHelper.voxelSpace(8.0, 1.85f, 3.5);

        Filter() {
        }

        @Override
        protected Vec3d getLocalOffset(BlockState state) {
            Vec3d location = this.offsetForHorizontal;
            if (state.func_177230_c() instanceof TransposerBlock) {
                location = location.func_72441_c(0.0, 0.125, 0.0);
            }
            if (AttachedLogisticalBlock.isVertical(state)) {
                location = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? this.offsetForUpward : this.offsetForDownward;
            }
            return this.rotateHorizontally(state, location);
        }

        @Override
        protected void rotate(BlockState state, MatrixStack ms) {
            float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            float xRot = AttachedLogisticalBlock.isVertical(state) ? 0.0f : 90.0f;
            MatrixStacker.of(ms).rotateY(yRot).rotateX(xRot);
        }
    }
}

