/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.NbtPacket;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Hand;

public class ZapperScreen
extends AbstractSimiScreen {
    protected ItemStack zapper;
    protected boolean offhand;
    protected float animationProgress;
    protected AllGuiTextures background;
    protected final String patternSection = Lang.translate("gui.blockzapper.patternSection", new Object[0]);
    protected String title;
    protected Vector<IconButton> patternButtons;
    protected int brightColor;
    protected int fontColor;

    public ZapperScreen(AllGuiTextures background, ItemStack zapper, boolean offhand) {
        this.background = background;
        this.zapper = zapper;
        this.offhand = offhand;
        this.title = "";
        this.brightColor = 0xCCDDFF;
        this.fontColor = 5726074;
    }

    protected void init() {
        this.animationProgress = 0.0f;
        this.setWindowSize(this.background.width + 40, this.background.height);
        super.init();
        this.widgets.clear();
        int i = this.guiLeft - 20;
        int j = this.guiTop;
        CompoundNBT nbt = this.zapper.func_196082_o();
        this.patternButtons = new Vector(6);
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                this.patternButtons.add(new IconButton(i + 147 + col * 18, j + 23 + row * 18, pattern.icon));
                this.patternButtons.get(id).setToolTip(Lang.translate("gui.blockzapper.pattern." + pattern.translationKey, new Object[0]));
            }
        }
        if (nbt.func_74764_b("Pattern")) {
            this.patternButtons.get((int)PlacementPatterns.valueOf((String)nbt.func_74779_i((String)"Pattern")).ordinal()).active = false;
        }
        this.widgets.addAll(this.patternButtons);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int i = this.guiLeft - 20;
        int j = this.guiTop;
        this.background.draw((AbstractGui)this, i, j);
        this.drawOnBackground(i, j);
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderSystem.enableBlend();
        this.renderBlock();
        this.renderZapper();
    }

    protected void drawOnBackground(int i, int j) {
        this.font.func_175063_a(this.title, (float)(i + 8), (float)(j + 10), this.brightColor);
        this.font.func_211126_b(this.patternSection, (float)(i + 148), (float)(j + 11), this.fontColor);
    }

    public void tick() {
        super.tick();
        this.animationProgress += 5.0f;
    }

    public void onClose() {
        CompoundNBT nbt = this.zapper.func_77978_p();
        this.writeAdditionalOptions(nbt);
        AllPackets.channel.sendToServer((Object)new NbtPacket(this.zapper, this.offhand ? Hand.OFF_HAND : Hand.MAIN_HAND));
        super.onClose();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        CompoundNBT nbt = this.zapper.func_77978_p();
        for (IconButton patternButton : this.patternButtons) {
            if (!patternButton.isHovered()) continue;
            this.patternButtons.forEach(b -> {
                b.active = true;
            });
            patternButton.active = false;
            patternButton.playDownSound(Minecraft.func_71410_x().func_147118_V());
            nbt.func_74778_a("Pattern", PlacementPatterns.values()[this.patternButtons.indexOf((Object)patternButton)].name());
        }
        return super.mouseClicked(x, y, button);
    }

    protected void renderZapper() {
        GuiGameElement.of(this.zapper).at((this.width - this.sWidth) / 2 + 210, this.height / 2 - this.sHeight / 4).scale(4.0).render();
    }

    protected void renderBlock() {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((float)this.guiLeft + 1.7f), (double)(this.guiTop + 48), (double)120.0);
        RenderSystem.rotatef((float)-30.0f, (float)0.5f, (float)0.9f, (float)-0.1f);
        RenderSystem.scaled((double)20.0, (double)20.0, (double)20.0);
        BlockState state = Blocks.field_150350_a.func_176223_P();
        if (this.zapper.func_77942_o() && this.zapper.func_77978_p().func_74764_b("BlockUsed")) {
            state = NBTUtil.func_190008_d((CompoundNBT)this.zapper.func_77978_p().func_74775_l("BlockUsed"));
        }
        GuiGameElement.of(state).render();
        RenderSystem.popMatrix();
    }

    protected void writeAdditionalOptions(CompoundNBT nbt) {
    }
}

