/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TextFormatting;

public class StressGaugeTileEntity
extends GaugeTileEntity {
    public StressGaugeTileEntity(TileEntityType<? extends StressGaugeTileEntity> type) {
        super(type);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.overStressed ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? ColorHelper.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? ColorHelper.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.func_70296_d();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.func_70296_d();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        tooltip.add("    " + TextFormatting.GRAY + Lang.translate("gui.stress_gauge.title", new Object[0]));
        if (this.getTheoreticalSpeed() == 0.0f) {
            tooltip.add(TextFormatting.DARK_GRAY + ItemDescription.makeProgressBar(3, -1) + Lang.translate("gui.stress_gauge.no_rotation", new Object[0]));
        } else {
            tooltip.add("    " + IRotate.StressImpact.getFormattedStressText(stressFraction));
            tooltip.add("    " + TextFormatting.GRAY + Lang.translate("gui.stress_gauge.capacity", new Object[0]));
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            double remainingCapacityAtBase = remainingCapacity / (double)Math.abs(this.getTheoreticalSpeed());
            String capacityString = "    " + IRotate.StressImpact.of(stressFraction).getRelativeColor() + "%s" + Lang.translate("generic.unit.stress", new Object[0]) + " " + TextFormatting.DARK_GRAY + "%s";
            tooltip.add(String.format(capacityString, IHaveGoggleInformation.format(remainingCapacityAtBase), Lang.translate("gui.goggles.base_value", new Object[0])));
            tooltip.add(String.format(capacityString, IHaveGoggleInformation.format(remainingCapacity), Lang.translate("gui.goggles.at_current_speed", new Object[0])));
        }
        return true;
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }
}

