/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.utility.ColorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeltTileEntity
extends KineticTileEntity {
    public Map<Entity, BeltMovementHandler.TransportedEntityInfo> passengers;
    public AllBeltAttachments.Tracker attachmentTracker;
    public int color = -1;
    public int beltLength;
    public int index;
    public Direction lastInsert;
    protected BlockPos controller = BlockPos.field_177992_a;
    protected BeltInventory inventory;
    protected LazyOptional<IItemHandler> itemHandler;
    public CompoundNBT trackerUpdateTag;

    public BeltTileEntity(TileEntityType<? extends BeltTileEntity> type) {
        super(type);
        this.attachmentTracker = new AllBeltAttachments.Tracker(this);
        this.itemHandler = LazyOptional.empty();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.field_145850_b, this.field_174879_c);
        }
        if (!AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return;
        }
        if (this.field_145850_b != null && this.trackerUpdateTag != null) {
            this.attachmentTracker.readAndSearch(this.trackerUpdateTag, this);
            this.trackerUpdateTag = null;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        this.getInventory().tick();
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.func_195044_w().func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isController()) {
            return super.getRenderBoundingBox();
        }
        return super.getRenderBoundingBox().func_186662_g((double)(this.beltLength + 1));
    }

    protected void initializeItemHandler() {
        if (this.field_145850_b.field_72995_K || this.itemHandler.isPresent()) {
            return;
        }
        if (!this.field_145850_b.func_195588_v(this.controller)) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltTileEntity)te).getInventory();
        if (inventory == null) {
            return;
        }
        IItemHandler handler = inventory.createHandlerForSegment(this.index);
        this.itemHandler = LazyOptional.of(() -> handler);
    }

    @Override
    public boolean hasFastRenderer() {
        return !this.isController();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (side == Direction.UP || BeltBlock.canAccessFromSide(side, this.func_195044_w()))) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandler.invalidate();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.attachmentTracker.write(compound);
        if (this.controller != null) {
            compound.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.controller));
        }
        compound.func_74757_a("IsController", this.isController());
        compound.func_74768_a("Color", this.color);
        compound.func_74768_a("Length", this.beltLength);
        compound.func_74768_a("Index", this.index);
        if (this.isController()) {
            compound.func_218657_a("Inventory", (INBT)this.getInventory().write());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74767_n("IsController")) {
            this.controller = this.field_174879_c;
        }
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Controller"));
            }
            this.trackerUpdateTag = compound;
            this.color = compound.func_74762_e("Color");
            this.beltLength = compound.func_74762_e("Length");
            this.index = compound.func_74762_e("Index");
        }
        if (this.isController()) {
            this.getInventory().read(compound.func_74775_l("Inventory"));
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new CompoundNBT();
    }

    public void applyColor(DyeColor colorIn) {
        int colorValue = colorIn.func_196055_e().field_76291_p;
        for (BlockPos blockPos : BeltBlock.getBeltChain(this.field_145850_b, this.getController())) {
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, blockPos);
            if (belt == null) continue;
            belt.color = belt.color == -1 ? colorValue : ColorHelper.mixColors(belt.color, colorValue, 0.5f);
            belt.func_70296_d();
            belt.sendData();
        }
    }

    public BeltTileEntity getControllerTE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.field_145850_b.func_195588_v(this.controller)) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)te;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.field_174879_c : this.controller;
    }

    public boolean isController() {
        return this.field_174879_c.equals((Object)this.controller);
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().func_176743_c().func_179524_a();
        if (this.getBeltFacing().func_176740_k() == Direction.Axis.X) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!AllBlocks.BELT.has(this.func_195044_w())) {
            return false;
        }
        return this.func_195044_w().func_177229_b(BeltBlock.PART) != BeltBlock.Part.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        Direction direction = this.getBeltFacing();
        if (this.func_195044_w().func_177229_b(BeltBlock.SLOPE) == BeltBlock.Slope.VERTICAL) {
            return false;
        }
        BeltBlock.Part part = (BeltBlock.Part)((Object)this.func_195044_w().func_177229_b(BeltBlock.PART));
        if (part == BeltBlock.Part.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.func_176743_c().func_179524_a() == 1) ^ direction.func_176740_k() == Direction.Axis.X;
        return part == BeltBlock.Part.START ^ movingPositively;
    }

    public Vec3i getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public Vec3i getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected Vec3i getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return BlockPos.field_177992_a;
        }
        BlockState blockState = this.func_195044_w();
        Direction beltFacing = (Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        BeltBlock.Slope slope = (BeltBlock.Slope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
        BeltBlock.Part part = (BeltBlock.Part)((Object)blockState.func_177229_b(BeltBlock.PART));
        Direction.Axis axis = beltFacing.func_176740_k();
        Direction movementFacing = Direction.func_181076_a((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        boolean bl = notHorizontal = blockState.func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.func_176734_d();
        }
        Vec3i movement = movementFacing.func_176730_m();
        boolean slopeBeforeHalf = part == BeltBlock.Part.END == (beltFacing.func_176743_c() == Direction.AxisDirection.POSITIVE);
        boolean bl2 = onSlope = notHorizontal && (part == BeltBlock.Part.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltBlock.Slope.UPWARD : BeltBlock.Slope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new Vec3i(movement.func_177958_n(), movingUp ? 1 : -1, movement.func_177952_p());
    }

    public Direction getMovementFacing() {
        Direction.Axis axis = this.getBeltFacing().func_176740_k();
        return Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)(this.getBeltMovementSpeed() < 0.0f ^ axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    protected Direction getBeltFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltTileEntity controllerTE = this.getControllerTE();
            if (controllerTE != null) {
                return controllerTE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    public boolean tryInsertingFromSide(Direction side, ItemStack stack, boolean simulate) {
        return this.tryInsertingFromSide(side, new TransportedItemStack(stack), simulate);
    }

    public boolean tryInsertingFromSide(Direction side, TransportedItemStack transportedStack, boolean simulate) {
        BeltTileEntity nextBeltController = this.getControllerTE();
        if (nextBeltController == null) {
            return false;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        if (!nextInventory.canInsertFrom(this.index, side)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        Direction movementFacing = this.getMovementFacing();
        if (!side.func_176740_k().func_200128_b()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.func_176743_c().func_179524_a() * 0.35f;
                if (side.func_176740_k() == Direction.Axis.X) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index : (float)(this.index + 1);
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        nextInventory.addItem(transportedStack);
        nextBeltController.func_70296_d();
        nextBeltController.sendData();
        return true;
    }
}

