/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.CancelPlayerFallPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public abstract class LinearActuatorTileEntity
extends KineticTileEntity
implements IControlContraption {
    public float offset;
    public boolean running;
    public boolean assembleNextTick;
    public ContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ScrollOptionBehaviour<IControlContraption.MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected float clientOffsetDiff;

    public LinearActuatorTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.setLazyTickRate(3);
        this.forceMove = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.MovementMode>(IControlContraption.MovementMode.class, Lang.translate("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        this.movementMode.withCallback(t -> {
            this.waitingForSpeedChange = false;
        });
        behaviours.add(this.movementMode);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.movedContraption != null) {
            this.movedContraption.collisionTick();
            if (!this.movedContraption.func_70089_S()) {
                this.movedContraption = null;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.clientOffsetDiff *= 0.75f;
        }
        if (this.waitingForSpeedChange && this.movedContraption != null) {
            if (this.field_145850_b.field_72995_K) {
                float syncSpeed = this.clientOffsetDiff / 2.0f;
                this.offset += syncSpeed;
                this.movedContraption.setContraptionMotion(this.toMotionVector(syncSpeed));
                return;
            }
            this.movedContraption.setContraptionMotion(Vec3d.field_186680_a);
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                if (this.getSpeed() == 0.0f) {
                    this.tryDisassemble();
                } else {
                    this.sendData();
                }
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        boolean contraptionPresent = this.movedContraption != null;
        float movementSpeed = this.getMovementSpeed();
        float newOffset = this.offset + movementSpeed;
        if ((int)newOffset != (int)this.offset) {
            this.visitNewPosition();
        }
        if (!contraptionPresent || !this.movedContraption.isStalled()) {
            this.offset = newOffset;
        }
        if (contraptionPresent) {
            this.applyContraptionMotion();
        }
        int extensionRange = this.getExtensionRange();
        if (this.offset <= 0.0f || this.offset >= (float)extensionRange) {
            float f = this.offset = this.offset <= 0.0f ? 0.0f : (float)extensionRange;
            if (!this.field_145850_b.field_72995_K) {
                this.applyContraptionMotion();
                this.applyContraptionPosition();
                this.tryDisassemble();
                if (this.waitingForSpeedChange) {
                    this.forceMove = true;
                    this.sendData();
                }
            }
            return;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    protected int getGridOffset(float offset) {
        return MathHelper.func_76125_a((int)((int)(offset + 0.5f)), (int)0, (int)this.getExtensionRange());
    }

    public float getInterpolatedOffset(float partialTicks) {
        float interpolatedOffset = MathHelper.func_76131_a((float)(this.offset + (partialTicks - 0.5f) * this.getMovementSpeed()), (float)0.0f, (float)this.getExtensionRange());
        return interpolatedOffset;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        this.waitingForSpeedChange = false;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = true;
        if (!this.field_145850_b.field_72995_K) {
            this.disassemble();
        }
        super.func_145843_s();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("Running", this.running);
        tag.func_74757_a("Waiting", this.waitingForSpeedChange);
        tag.func_74776_a("Offset", this.offset);
        return super.func_189515_b(tag);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        if (this.forceMove) {
            compound.func_74757_a("ForceMovement", this.forceMove);
            this.forceMove = false;
        }
        return super.writeToClient(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.running = tag.func_74767_n("Running");
        this.waitingForSpeedChange = tag.func_74767_n("Waiting");
        this.offset = tag.func_74760_g("Offset");
        super.func_145839_a(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        boolean forceMovement = tag.func_74764_b("ForceMovement");
        float offsetBefore = this.offset;
        super.readClientUpdate(tag);
        if (forceMovement) {
            if (this.movedContraption != null) {
                this.applyContraptionPosition();
            }
        } else if (this.running) {
            this.clientOffsetDiff = this.offset - offsetBefore;
            this.offset = offsetBefore;
        }
        if (!this.running) {
            this.movedContraption = null;
        }
    }

    public abstract void disassemble();

    protected abstract void assemble();

    protected abstract int getExtensionRange();

    protected abstract int getInitialOffset();

    protected abstract ValueBoxTransform getMovementModeSlot();

    protected abstract Vec3d toMotionVector(float var1);

    protected abstract Vec3d toPosition(float var1);

    protected void visitNewPosition() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (!ContraptionCollider.wasClientPlayerGrounded) {
            return;
        }
        ContraptionCollider.wasClientPlayerGrounded = false;
        AllPackets.channel.sendToServer((Object)new CancelPlayerFallPacket());
    }

    protected void tryDisassemble() {
        if (this.field_145846_f) {
            this.disassemble();
            return;
        }
        if (this.movementMode.get() == IControlContraption.MovementMode.MOVE_NEVER_PLACE) {
            this.waitingForSpeedChange = true;
            return;
        }
        int initial = this.getInitialOffset();
        if ((int)(this.offset + 0.5f) != initial && this.movementMode.get() == IControlContraption.MovementMode.MOVE_PLACE_RETURNED) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.disassemble();
    }

    @Override
    public void collided() {
        if (this.field_145850_b.field_72995_K) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.offset = this.getGridOffset(this.offset - this.getMovementSpeed());
        this.applyContraptionPosition();
        this.tryDisassemble();
    }

    protected void applyContraptionMotion() {
        if (this.movedContraption == null) {
            return;
        }
        if (this.movedContraption.isStalled()) {
            this.movedContraption.setContraptionMotion(Vec3d.field_186680_a);
            return;
        }
        this.movedContraption.setContraptionMotion(this.getMotionVector());
    }

    protected void applyContraptionPosition() {
        if (this.movedContraption == null) {
            return;
        }
        Vec3d vec = this.toPosition(this.offset);
        this.movedContraption.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        if (this.getSpeed() == 0.0f || this.waitingForSpeedChange) {
            this.movedContraption.setContraptionMotion(Vec3d.field_186680_a);
        }
    }

    public float getMovementSpeed() {
        float movementSpeed = this.getSpeed() / 512.0f + this.clientOffsetDiff / 2.0f;
        if (this.field_145850_b.field_72995_K) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public Vec3d getMotionVector() {
        return this.toMotionVector(this.getMovementSpeed());
    }

    @Override
    public void onStall() {
        if (!this.field_145850_b.field_72995_K) {
            this.forceMove = true;
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void attach(ContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.field_145850_b.field_72995_K) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public boolean isAttachedTo(ContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }
}

